/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class DefaultTimerThreadPoolAdapter
implements ThreadPool {
    private static final Logger logger = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private Executor executor;
    private String instanceId;
    private String instanceName;
    private final Object threadAvailableLock = new Object();
    private boolean threadPoolExecutorUsed;

    public DefaultTimerThreadPoolAdapter() {
        this.executor = SystemInstance.get().getComponent(Executor.class);
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(10, new DaemonThreadFactory(DefaultTimerThreadPoolAdapter.class));
            SystemInstance.get().setComponent(Executor.class, this.executor);
        }
        this.threadPoolExecutorUsed = this.executor instanceof ThreadPoolExecutor;
        if (!this.threadPoolExecutorUsed) {
            logger.warning("Unrecognized ThreadPool implementation [" + this.executor.getClass().getName() + "] is used, EJB Timer service may not work correctly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int blockForAvailableThreads() {
        if (this.threadPoolExecutorUsed) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
            Object object = this.threadAvailableLock;
            synchronized (object) {
                while (threadPoolExecutor.getMaximumPoolSize() - threadPoolExecutor.getActiveCount() < 1 && !threadPoolExecutor.isShutdown()) {
                    try {
                        this.threadAvailableLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return threadPoolExecutor.getMaximumPoolSize() - threadPoolExecutor.getActiveCount();
            }
        }
        return 1;
    }

    @Override
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public int getPoolSize() {
        if (this.threadPoolExecutorUsed) {
            return ((ThreadPoolExecutor)this.executor).getPoolSize();
        }
        return 1;
    }

    @Override
    public void initialize() throws SchedulerConfigException {
    }

    @Override
    public boolean runInThread(Runnable runnable) {
        try {
            this.executor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            logger.error("Fail to executor timer task", e);
            return false;
        }
    }

    @Override
    public void shutdown(boolean arg0) {
    }
}

