/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;

final class LogicalStream {
    private final Queue<Entry> output = new ConcurrentLinkedQueue<Entry>();

    LogicalStream() {
    }

    synchronized void write(boolean stdout, String text, boolean newLine) {
        this.output.add(new Entry(stdout, text, newLine));
    }

    void writeDetails(ConsoleOutputReceiver outputReceiver) {
        Entry entry = this.output.poll();
        while (entry != null) {
            outputReceiver.writeTestOutput(entry.text, entry.newLine, entry.stdout);
            entry = this.output.poll();
        }
    }

    private static final class Entry {
        private final boolean stdout;
        private final String text;
        private final boolean newLine;

        Entry(boolean stdout, String text, boolean newLine) {
            this.stdout = stdout;
            this.text = text;
            this.newLine = newLine;
        }
    }
}

