/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.repository;

import java.io.File;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.codehaus.plexus.util.StringUtils;

public class HgScmProviderRepository
extends ScmProviderRepositoryWithHost {
    private static final String FILE = "";
    private static final String SFTP = "sftp://";
    private static final String FTP = "ftp://";
    private static final String AFTP = "aftp://";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private final String path;
    private final String protocol;
    private final String orgUrl;

    public HgScmProviderRepository(String url) {
        this.orgUrl = url;
        this.protocol = this.getProtocol(url);
        this.path = this.parseUrl(url);
    }

    public String getURI() {
        return this.protocol + (this.needsAuthentication() ? this.addUser() + this.addPassword() + this.addAt() : FILE) + this.addHost() + this.addPort() + this.addPath();
    }

    public String validateURI() {
        String msg = null;
        if (this.needsAuthentication()) {
            if (this.getUser() == null) {
                msg = "Username is missing for protocol " + this.protocol;
            } else if (this.getPassword() == null) {
                msg = "Password is missing for protocol " + this.protocol;
            } else if (this.getHost() == null) {
                msg = "Host (eg. www.myhost.com) is missing for protocol " + this.protocol;
            }
        } else if (this.getPort() != 0 && this.getHost() == null) {
            msg = "Got port information without any host for protocol " + this.protocol;
        }
        if (msg != null) {
            msg = "Something could be wrong about the repository URL: " + this.orgUrl + "\nReason: " + msg + "\nCheck http://maven.apache.org/scm for usage and hints.";
        }
        return msg;
    }

    private String getProtocol(String url) {
        String prot = FILE;
        if (url.startsWith(SFTP)) {
            prot = SFTP;
        } else if (url.startsWith(HTTP)) {
            prot = HTTP;
        } else if (url.startsWith(HTTPS)) {
            prot = HTTPS;
        }
        return prot;
    }

    private String parseUrl(String url) {
        if (this.protocol == FILE) {
            return url;
        }
        url = url.substring(this.protocol.length());
        url = this.parseUsernameAndPassword(url);
        url = this.parseHostAndPort(url);
        url = this.parsePath(url);
        return url;
    }

    private String parseHostAndPort(String url) {
        if (this.protocol != FILE) {
            String[] split = url.split(":");
            if (split.length == 2) {
                this.setHost(split[0]);
                url = url.substring(split[0].length() + 1);
                split = split[1].split("/");
                if (split.length == 2) {
                    url = url.substring(split[0].length());
                    try {
                        this.setPort(Integer.valueOf(split[0]));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                split = url.split("/");
                if (split.length > 1) {
                    url = url.substring(split[0].length());
                    this.setHost(split[0]);
                }
            }
        }
        return url;
    }

    private String parseUsernameAndPassword(String url) {
        String[] split;
        if (this.needsAuthentication() && (split = url.split("@")).length == 2) {
            url = split[1];
            if ((split = split[0].split(":")).length == 2) {
                this.setUser(split[0]);
                this.setPassword(split[1]);
            } else {
                this.setUser(split[0]);
            }
        }
        return url;
    }

    private String parsePath(String url) {
        if (this.protocol == FILE) {
            url = StringUtils.replace((String)url, (String)"/", (String)File.separator);
            File tmpFile = new File(url);
            String url2 = url.substring(File.pathSeparator.length());
            File tmpFile2 = new File(url2);
            if (tmpFile.exists() || !tmpFile2.exists()) {
                // empty if block
            }
            url = tmpFile2.exists() ? url2 : url;
        }
        return url;
    }

    private String addUser() {
        return this.getUser() == null ? FILE : this.getUser();
    }

    private String addPassword() {
        return this.getPassword() == null ? FILE : ":" + this.getPassword();
    }

    private String addAt() {
        return this.needsAuthentication() ? "@" : FILE;
    }

    private String addHost() {
        return this.getHost() == null ? FILE : this.getHost();
    }

    private String addPort() {
        return this.getPort() == 0 ? FILE : ":" + this.getPort();
    }

    private String addPath() {
        return this.path;
    }

    private boolean needsAuthentication() {
        return this.protocol == SFTP || this.protocol == FTP || this.protocol == HTTPS || this.protocol == AFTP;
    }

    public String toString() {
        return "Hg Repository Interpreted from: " + this.orgUrl + ":\nProtocol: " + this.protocol + "\nHost: " + this.getHost() + "\nPort: " + this.getPort() + "\nUsername: " + this.getUser() + "\nPassword: " + this.getPassword() + "\nPath: " + this.path;
    }
}

