/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ResourceBundle;
import org.apache.maven.scm.providers.clearcase.settings.Settings;
import org.apache.maven.scm.providers.clearcase.settings.io.xpp3.ClearcaseXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ClearCaseUtil {
    protected static final String CLEARCASE_SETTINGS_FILENAME = "clearcase-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;
    private static final String RESOURCE_FILENAME = "org.apache.maven.scm.provider.clearcase.command.clearcase";
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static Settings settings;

    private ClearCaseUtil() {
    }

    public static String getLocalizedResource(String key) {
        return RESOURCE_BUNDLE.getString(key);
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = ClearCaseUtil.readSettings();
        }
        return settings;
    }

    public static Settings readSettings() {
        File settingsFile = new File(settingsDirectory, CLEARCASE_SETTINGS_FILENAME);
        if (!settingsFile.exists()) {
            File scmGlobalDir = new File(System.getProperty("maven.home"), "conf");
            settingsFile = new File(scmGlobalDir, CLEARCASE_SETTINGS_FILENAME);
        }
        if (settingsFile.exists()) {
            ClearcaseXpp3Reader reader = new ClearcaseXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.out.println(message);
            }
        }
        return new Settings();
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
        settings = ClearCaseUtil.readSettings();
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
        RESOURCE_BUNDLE = ResourceBundle.getBundle(RESOURCE_FILENAME);
    }
}

