/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.deploy;

import java.io.File;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.deploy.AbstractStagingMojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="stage", requiresDependencyResolution=ResolutionScope.TEST)
public class SiteStageMojo
extends AbstractStagingMojo {
    @Parameter(property="stagingDirectory")
    private File stagingDirectory;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven.site.skip = true: Skipping site staging");
            return;
        }
        super.execute();
    }

    @Override
    protected boolean isDeploy() {
        return false;
    }

    @Override
    protected Site determineDeploySite() throws MojoExecutionException {
        Site staging = new Site();
        staging.setId("stagingLocal");
        File outputDirectory = this.determineStagingDirectory();
        this.getLog().info((CharSequence)("Using this base directory for staging: " + outputDirectory));
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        staging.setUrl("file://" + outputDirectory.getAbsolutePath());
        return staging;
    }

    private File determineStagingDirectory() {
        if (this.stagingDirectory != null) {
            this.getLog().debug((CharSequence)("stagingDirectory specified by the user: " + this.stagingDirectory));
            return this.stagingDirectory;
        }
        File defaultStagingDirectory = new File(this.getExecutionRootBuildDirectory(), "staging/");
        this.getLog().debug((CharSequence)("stagingDirectory NOT specified, using the execution root project: " + defaultStagingDirectory));
        return defaultStagingDirectory;
    }

    protected File getExecutionRootBuildDirectory() {
        File buildDirectory;
        MavenProject executionRootProject = this.mavenSession.getTopLevelProject();
        if (executionRootProject == null) {
            this.getLog().debug((CharSequence)"No execution root project found in the reactor, using the current project.");
            buildDirectory = new File(this.project.getBuild().getDirectory());
        } else {
            this.getLog().debug((CharSequence)("Using the execution root project found in the reactor: " + executionRootProject.getArtifactId()));
            buildDirectory = new File(executionRootProject.getBuild().getDirectory());
        }
        return buildDirectory;
    }
}

