/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractSiteMojo
extends AbstractMojo {
    protected String locales;
    protected SiteTool siteTool;
    protected I18N i18n;
    protected File siteDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected List<MavenProject> reactorProjects;
    private String inputEncoding;
    private String outputEncoding;

    protected String getInputEncoding() {
        return this.inputEncoding == null ? "ISO-8859-1" : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected void checkMavenVersion() {
        try {
            String version = this.getMavenVersion();
            if (version.startsWith("3")) {
                this.getLog().warn((CharSequence)"Running 2.x site-plugin with Maven 3, use site-plugin-3.x instead!");
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)"Unable to determine Maven version", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMavenVersion() throws IOException {
        Properties properties = new Properties();
        InputStream in = MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
        try {
            properties.load(in);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
        return properties.getProperty("version").trim();
    }
}

