/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.util.Collection;
import java.util.HashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.shade.mojo.ArtifactId;
import org.apache.maven.plugins.shade.mojo.ArtifactSet;

class ArtifactSelector {
    private Collection includes;
    private Collection excludes;

    public ArtifactSelector(Artifact projectArtifact, ArtifactSet artifactSet, String groupPrefix) {
        this(artifactSet != null ? artifactSet.getIncludes() : null, artifactSet != null ? artifactSet.getExcludes() : null, groupPrefix);
        if (projectArtifact != null && !this.includes.isEmpty()) {
            this.includes.add(new ArtifactId(projectArtifact));
        }
    }

    public ArtifactSelector(Collection includes, Collection excludes, String groupPrefix) {
        this.includes = ArtifactSelector.toIds(includes);
        this.excludes = ArtifactSelector.toIds(excludes);
        if (groupPrefix != null && groupPrefix.length() > 0) {
            this.includes.add(new ArtifactId(groupPrefix + "*", "*", "*", "*"));
        }
    }

    private static Collection toIds(Collection patterns) {
        HashSet<ArtifactId> result = new HashSet<ArtifactId>();
        if (patterns != null) {
            for (String pattern : patterns) {
                result.add(new ArtifactId(pattern));
            }
        }
        return result;
    }

    public boolean isSelected(Artifact artifact) {
        return artifact != null ? this.isSelected(new ArtifactId(artifact)) : false;
    }

    boolean isSelected(ArtifactId id) {
        return (this.includes.isEmpty() || this.matches(this.includes, id)) && !this.matches(this.excludes, id);
    }

    private boolean matches(Collection patterns, ArtifactId id) {
        for (ArtifactId pattern : patterns) {
            if (!id.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

