/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="export", requiresProject=false)
public class ExportMojo
extends AbstractScmMojo {
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    @Parameter(property="exportDirectory", defaultValue="${project.build.directory}/export", required=true)
    private File exportDirectory;
    @Parameter(property="skipExportIfExists", defaultValue="false")
    private boolean skipExportIfExists = false;

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.skipExportIfExists && this.exportDirectory.isDirectory()) {
            return;
        }
        this.export();
    }

    protected File getExportDirectory() {
        return this.exportDirectory;
    }

    public void setExportDirectory(File exportDirectory) {
        this.exportDirectory = exportDirectory;
    }

    protected void export() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            try {
                if (this.exportDirectory.exists()) {
                    this.getLog().info((CharSequence)("Removing " + this.exportDirectory));
                    FileUtils.deleteDirectory((File)this.exportDirectory);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot remove " + this.getExportDirectory());
            }
            if (!this.exportDirectory.mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.exportDirectory);
            }
            ExportScmResult result = this.getScmManager().export(repository, new ScmFileSet(this.exportDirectory.getAbsoluteFile()), this.getScmVersion(this.scmVersionType, this.scmVersion));
            this.checkResult((ScmResult)result);
            this.handleExcludesIncludesAfterCheckoutAndExport(this.exportDirectory);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run export command : ", (Exception)((Object)e));
        }
    }
}

