/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

public class ListMojo
extends AbstractScmMojo {
    private String scmVersionType;
    private String scmVersion;
    private boolean recursive = true;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            ListScmResult result = this.getScmManager().list(repository, this.getFileSet(), this.recursive, this.getScmVersion(this.scmVersionType, this.scmVersion));
            this.checkResult((ScmResult)result);
            if (result.getFiles() != null) {
                Iterator i = result.getFiles().iterator();
                while (i.hasNext()) {
                    ScmFile scmFile = (ScmFile)i.next();
                    this.getLog().info((CharSequence)scmFile.getPath());
                }
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run list command : ", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run list command : ", (Exception)e);
        }
    }

    public ScmFileSet getFileSet() throws IOException {
        if (this.getIncludes() != null || this.getExcludes() != null) {
            return new ScmFileSet(this.getWorkingDirectory(), this.getIncludes(), this.getExcludes());
        }
        return new ScmFileSet(this.getWorkingDirectory(), new File("."));
    }
}

