/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScmMojo
extends AbstractMojo {
    private String connectionUrl;
    private String developerConnectionUrl;
    private String connectionType;
    private File workingDirectory;
    private String username;
    private String password;
    private String privateKey;
    private String passphrase;
    private String tagBase;
    private String includes;
    private String excludes;
    private ScmManager manager;
    private File basedir;
    private Settings settings;
    private Properties systemProperties;
    private Map providerImplementations;
    private boolean pushChanges;

    public void execute() throws MojoExecutionException {
        if (this.systemProperties != null) {
            Iterator<Object> iter = this.systemProperties.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = this.systemProperties.getProperty(key);
                System.setProperty(key, value);
            }
        }
        if (this.providerImplementations != null) {
            Iterator i = this.providerImplementations.keySet().iterator();
            while (i.hasNext()) {
                String providerType = (String)i.next();
                String providerImplementation = (String)this.providerImplementations.get(providerType);
                this.getLog().info((CharSequence)("Change the default '" + providerType + "' provider implementation to '" + providerImplementation + "'."));
                this.getScmManager().setScmProviderImplementation(providerType, providerImplementation);
            }
        }
    }

    protected void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionUrl() {
        boolean requireDeveloperConnection;
        boolean bl = requireDeveloperConnection = !"connection".equals(this.connectionType.toLowerCase());
        if (StringUtils.isNotEmpty((String)this.connectionUrl) && !requireDeveloperConnection) {
            return this.connectionUrl;
        }
        if (StringUtils.isNotEmpty((String)this.developerConnectionUrl)) {
            return this.developerConnectionUrl;
        }
        if (requireDeveloperConnection) {
            throw new NullPointerException("You need to define a developerConnectionUrl parameter");
        }
        throw new NullPointerException("You need to define a connectionUrl parameter");
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            return this.basedir;
        }
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public ScmManager getScmManager() {
        return this.manager;
    }

    public ScmFileSet getFileSet() throws IOException {
        if (this.includes != null || this.excludes != null) {
            return new ScmFileSet(this.getWorkingDirectory(), this.includes, this.excludes);
        }
        return new ScmFileSet(this.getWorkingDirectory());
    }

    public ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(this.getConnectionUrl());
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            providerRepo.setPushChanges(this.pushChanges);
            if (!StringUtils.isEmpty((String)this.username)) {
                providerRepo.setUser(this.username);
            }
            if (!StringUtils.isEmpty((String)this.password)) {
                providerRepo.setPassword(this.password);
            }
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.loadInfosFromSettings(repo);
                if (!StringUtils.isEmpty((String)this.username)) {
                    repo.setUser(this.username);
                }
                if (!StringUtils.isEmpty((String)this.password)) {
                    repo.setPassword(this.password);
                }
                if (!StringUtils.isEmpty((String)this.privateKey)) {
                    repo.setPrivateKey(this.privateKey);
                }
                if (!StringUtils.isEmpty((String)this.passphrase)) {
                    repo.setPassphrase(this.passphrase);
                }
            }
            if (!StringUtils.isEmpty((String)this.tagBase) && repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                svnRepo.setTagBase(this.tagBase);
            }
        }
        catch (ScmRepositoryException e) {
            if (!e.getValidationMessages().isEmpty()) {
                Iterator i = e.getValidationMessages().iterator();
                while (i.hasNext()) {
                    String message = (String)i.next();
                    this.getLog().error((CharSequence)message);
                }
            }
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                if (this.username == null) {
                    this.username = this.settings.getServer(host).getUsername();
                }
                if (this.password == null) {
                    this.password = this.settings.getServer(host).getPassword();
                }
                if (this.privateKey == null) {
                    this.privateKey = this.settings.getServer(host).getPrivateKey();
                }
                if (this.passphrase == null) {
                    this.passphrase = this.settings.getServer(host).getPassphrase();
                }
            }
        }
    }

    public void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed." + StringUtils.defaultString((Object)result.getProviderMessage()));
        }
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public ScmVersion getScmVersion(String versionType, String version) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)versionType) && StringUtils.isNotEmpty((String)version)) {
            throw new MojoExecutionException("You must specify the version type.");
        }
        if (StringUtils.isEmpty((String)version)) {
            return null;
        }
        if ("branch".equals(versionType)) {
            return new ScmBranch(version);
        }
        if ("tag".equals(versionType)) {
            return new ScmTag(version);
        }
        if ("revision".equals(versionType)) {
            return new ScmRevision(version);
        }
        throw new MojoExecutionException("Unknown '" + versionType + "' version type.");
    }

    protected void handleExcludesIncludesAfterCheckoutAndExport(File checkoutDirectory) throws MojoExecutionException {
        ArrayList<String> includes = new ArrayList<String>();
        if (!StringUtils.isBlank((String)this.getIncludes())) {
            String[] tokens = StringUtils.split((String)this.getIncludes(), (String)",");
            for (int i = 0; i < tokens.length; ++i) {
                includes.add(tokens[i]);
            }
        }
        ArrayList<String> excludes = new ArrayList<String>();
        if (!StringUtils.isBlank((String)this.getExcludes())) {
            String[] tokens = StringUtils.split((String)this.getExcludes(), (String)",");
            for (int i = 0; i < tokens.length; ++i) {
                excludes.add(tokens[i]);
            }
        }
        if (includes.isEmpty() && excludes.isEmpty()) {
            return;
        }
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fileset = new FileSet();
        fileset.setDirectory(checkoutDirectory.getAbsolutePath());
        fileset.setIncludes(excludes);
        fileset.setExcludes(includes);
        fileset.setUseDefaultExcludes(false);
        try {
            fileSetManager.delete(fileset);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error found while cleaning up output directory base on excludes/includes configurations.", (Exception)e);
        }
    }
}

