/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources.remote;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.resources.remote.RemoteResourcesBundle;
import org.apache.maven.plugin.resources.remote.RemoteResourcesClassLoader;
import org.apache.maven.plugin.resources.remote.Supplement;
import org.apache.maven.plugin.resources.remote.SupplementalDataModel;
import org.apache.maven.plugin.resources.remote.io.xpp3.RemoteResourcesBundleXpp3Reader;
import org.apache.maven.plugin.resources.remote.io.xpp3.SupplementalDataModelXpp3Reader;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class ProcessRemoteResourcesMojo
extends AbstractMojo
implements LogChute {
    private static final String TEMPLATE_SUFFIX = ".vm";
    @Parameter
    protected List<String> filterDelimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultFilterDelimiters;
    @Parameter(defaultValue="false")
    protected boolean runOnlyAtExecutionRoot;
    @Parameter(defaultValue="${basedir}", readonly=true, required=true)
    protected File basedir;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/maven-shared-archive-resources")
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}/src/main/appended-resources")
    private File appendedResourcesDirectory;
    @Parameter
    private String[] supplementalModels;
    @Parameter
    private List<String> supplementalModelArtifacts;
    private Map<String, Model> supplementModels;
    @Component
    private ModelInheritanceAssembler inheritanceAssembler;
    @Parameter(required=true)
    private List<String> resourceBundles;
    @Parameter(property="remoteresources.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true", property="attachToMain")
    private boolean attachToMain;
    @Parameter(defaultValue="true", property="attachToTest")
    private boolean attachToTest;
    @Parameter
    private Map<String, Object> properties = new HashMap<String, Object>();
    @Parameter(defaultValue="false")
    protected boolean includeProjectProperties = false;
    @Parameter(defaultValue="5242880")
    protected int velocityFilterInMemoryThreshold = 0x500000;
    @Parameter(defaultValue="${project.resources}", readonly=true, required=true)
    private List<Resource> resources;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private MavenFileFilter fileFilter;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Component(role=MavenProjectBuilder.class)
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    private ResourceManager locator;
    @Parameter(property="includeScope", defaultValue="runtime")
    protected String includeScope;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter
    private String[] resolveScopes;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter(property="excludeTransitive", defaultValue="false")
    protected boolean excludeTransitive;
    @Component(hint="default")
    protected ProjectDependenciesResolver dependencyResolver;
    private VelocityEngine velocity;
    private static final String KEY_PROJECTS = "projects";
    private static final String KEY_PROJECTS_ORGS = "projectsSortedByOrganization";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block16: {
            File sups;
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping remote resources execution.");
                return;
            }
            if (StringUtils.isEmpty((String)this.encoding)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            if (this.runOnlyAtExecutionRoot && !this.project.isExecutionRoot()) {
                this.getLog().info((CharSequence)"Skipping remote-resource generation in this project because it's not the Execution Root");
                return;
            }
            if (this.resolveScopes == null) {
                this.resolveScopes = new String[]{StringUtils.isEmpty((String)this.excludeScope) ? this.includeScope : "test"};
            }
            if (this.supplementalModels == null && (sups = new File(this.appendedResourcesDirectory, "supplemental-models.xml")).exists()) {
                try {
                    this.supplementalModels = new String[]{sups.toURI().toURL().toString()};
                }
                catch (MalformedURLException e) {
                    this.getLog().debug((CharSequence)("URL issue with supplemental-models.xml: " + e.toString()));
                }
            }
            this.configureLocator();
            if (this.includeProjectProperties) {
                Properties projectProperties = this.project.getProperties();
                for (Object key : projectProperties.keySet()) {
                    this.properties.put(key.toString(), projectProperties.get(key).toString());
                }
            }
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.validate();
                List<File> resourceBundleArtifacts = this.downloadBundles(this.resourceBundles);
                this.supplementModels = this.loadSupplements(this.supplementalModels);
                ClassLoader classLoader = this.initalizeClassloader(resourceBundleArtifacts);
                Thread.currentThread().setContextClassLoader(classLoader);
                this.velocity = new VelocityEngine();
                this.velocity.setProperty("runtime.log.logsystem", (Object)this);
                this.velocity.setProperty("resource.loader", (Object)"classpath");
                this.velocity.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
                this.velocity.init();
                VelocityContext context = this.buildVelocityContext(this.properties);
                this.processResourceBundles(classLoader, context);
                if (!this.outputDirectory.exists()) break block16;
                Resource resource = new Resource();
                resource.setDirectory(this.outputDirectory.getAbsolutePath());
                if (this.attachToMain) {
                    this.project.getResources().add(resource);
                }
                if (this.attachToTest) {
                    this.project.getTestResources().add(resource);
                }
                try {
                    File dotFile = new File(this.project.getBuild().getDirectory(), ".plxarc");
                    FileUtils.mkdir((String)dotFile.getParentFile().getAbsolutePath());
                    FileUtils.fileWrite((String)dotFile.getAbsolutePath(), (String)this.outputDirectory.getName());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating dot file for archiving instructions.", (Exception)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    private void configureLocator() throws MojoExecutionException {
        if (this.supplementalModelArtifacts != null && !this.supplementalModelArtifacts.isEmpty()) {
            List<File> artifacts = this.downloadBundles(this.supplementalModelArtifacts);
            for (File artifact : artifacts) {
                if (artifact.isDirectory()) {
                    this.locator.addSearchPath("file", artifact.getAbsolutePath());
                    continue;
                }
                try {
                    this.locator.addSearchPath("jar", "jar:" + artifact.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Could not use jar " + artifact.getAbsolutePath(), (Exception)e);
                }
            }
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        if (this.appendedResourcesDirectory != null) {
            this.locator.addSearchPath("file", this.appendedResourcesDirectory.getAbsolutePath());
        }
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
    }

    protected List<MavenProject> getProjects() {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        FilterArtifacts filter = new FilterArtifacts();
        Set artifacts = this.resolveProjectArtifacts();
        if (this.excludeTransitive) {
            Set depArtifacts = this.runOnlyAtExecutionRoot ? this.aggregateProjectDependencyArtifacts() : this.project.getDependencyArtifacts();
            filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(depArtifacts, true));
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.includeScope, this.excludeScope));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(this.includeGroupIds, this.excludeGroupIds));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(this.includeArtifactIds, this.excludeArtifactIds));
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        for (Artifact artifact : artifacts) {
            try {
                MavenProject p;
                List<ArtifactRepository> remoteRepo = this.remoteArtifactRepositories;
                if (artifact.isSnapshot()) {
                    VersionRange rng = VersionRange.createFromVersion((String)artifact.getBaseVersion());
                    artifact = this.artifactFactory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), rng, artifact.getType(), artifact.getClassifier(), artifact.getScope(), null, artifact.isOptional());
                }
                this.getLog().debug((CharSequence)("Building project for " + artifact));
                try {
                    p = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepo, this.localRepository);
                }
                catch (InvalidProjectModelException e) {
                    this.getLog().warn((CharSequence)("Invalid project model for artifact [" + artifact.getArtifactId() + ":" + artifact.getGroupId() + ":" + artifact.getVersion() + "]. " + "It will be ignored by the remote resources Mojo."));
                    continue;
                }
                String supplementKey = ProcessRemoteResourcesMojo.generateSupplementMapKey(p.getModel().getGroupId(), p.getModel().getArtifactId());
                if (this.supplementModels.containsKey(supplementKey)) {
                    Model mergedModel = this.mergeModels(p.getModel(), this.supplementModels.get(supplementKey));
                    MavenProject mergedProject = new MavenProject(mergedModel);
                    projects.add(mergedProject);
                    mergedProject.setArtifact(artifact);
                    mergedProject.setVersion(artifact.getVersion());
                    this.getLog().debug((CharSequence)("Adding project with groupId [" + mergedProject.getGroupId() + "] (supplemented)"));
                    continue;
                }
                projects.add(p);
                this.getLog().debug((CharSequence)("Adding project with groupId [" + p.getGroupId() + "]"));
            }
            catch (ProjectBuildingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        Collections.sort(projects, new ProjectComparator());
        return projects;
    }

    private Set<Artifact> resolveProjectArtifacts() {
        try {
            if (this.runOnlyAtExecutionRoot) {
                List projects = this.mavenSession.getSortedProjects();
                return this.dependencyResolver.resolve((Collection)projects, Arrays.asList(this.resolveScopes), this.mavenSession);
            }
            return this.dependencyResolver.resolve(this.project, Arrays.asList(this.resolveScopes), this.mavenSession);
        }
        catch (ArtifactResolutionException e) {
            throw new IllegalStateException("Failed to resolve dependencies for one or more projects in the reactor. Reason: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new IllegalStateException("Failed to resolve dependencies for one or more projects in the reactor. Reason: " + e.getMessage(), e);
        }
    }

    private Set<Artifact> aggregateProjectDependencyArtifacts() {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        List projects = this.mavenSession.getSortedProjects();
        for (MavenProject p : projects) {
            if (p.getDependencyArtifacts() != null) continue;
            try {
                Set depArtifacts = p.createArtifacts(this.artifactFactory, null, null);
                if (depArtifacts == null || depArtifacts.isEmpty()) continue;
                for (Artifact artifact : depArtifacts) {
                    if (artifact.getVersion() == null && artifact.getVersionRange() != null) {
                        artifact.setResolvedVersion("LATEST");
                    }
                    artifacts.add(artifact);
                }
            }
            catch (InvalidDependencyVersionException e) {
                throw new IllegalStateException("Failed to create dependency artifacts for: " + p.getId() + ". Reason: " + e.getMessage(), e);
            }
        }
        return artifacts;
    }

    protected Map<Organization, List<MavenProject>> getProjectsSortedByOrganization(List<MavenProject> projects) {
        TreeMap<Organization, List<MavenProject>> organizations = new TreeMap<Organization, List<MavenProject>>(new OrganizationComparator());
        ArrayList<MavenProject> unknownOrganization = new ArrayList<MavenProject>();
        for (MavenProject p : projects) {
            if (p.getOrganization() != null && StringUtils.isNotEmpty((String)p.getOrganization().getName())) {
                ArrayList<MavenProject> sortedProjects = (ArrayList<MavenProject>)organizations.get(p.getOrganization());
                if (sortedProjects == null) {
                    sortedProjects = new ArrayList<MavenProject>();
                }
                sortedProjects.add(p);
                organizations.put(p.getOrganization(), sortedProjects);
                continue;
            }
            unknownOrganization.add(p);
        }
        if (!unknownOrganization.isEmpty()) {
            Organization unknownOrg = new Organization();
            unknownOrg.setName("an unknown organization");
            organizations.put(unknownOrg, unknownOrganization);
        }
        return organizations;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean copyResourceIfExists(File file, String relFileName, VelocityContext context) throws IOException, MojoExecutionException {
        File templateSource;
        File source;
        Resource resource;
        Iterator<Resource> i$ = this.resources.iterator();
        while (true) {
            if (!i$.hasNext()) {
                return false;
            }
            resource = i$.next();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.exists()) continue;
            source = new File(resourceDirectory, relFileName);
            templateSource = new File(resourceDirectory, relFileName + TEMPLATE_SUFFIX);
            if (!source.exists() && templateSource.exists()) {
                source = templateSource;
            }
            if (source.exists() && !source.equals(file)) break;
        }
        if (source == templateSource) {
            Reader reader = null;
            Writer writer = null;
            DeferredFileOutputStream os = new DeferredFileOutputStream(this.velocityFilterInMemoryThreshold, file);
            try {
                if (this.encoding != null) {
                    reader = new InputStreamReader((InputStream)new FileInputStream(source), this.encoding);
                    writer = new OutputStreamWriter((OutputStream)os, this.encoding);
                } else {
                    reader = ReaderFactory.newPlatformReader((File)source);
                    writer = WriterFactory.newPlatformWriter((OutputStream)os);
                }
                this.velocity.evaluate((Context)context, writer, "", reader);
                writer.close();
                writer = null;
                reader.close();
                reader = null;
            }
            catch (ParseErrorException e) {
                try {
                    throw new MojoExecutionException("Error rendering velocity resource: " + source, (Exception)((Object)e));
                    catch (MethodInvocationException e2) {
                        throw new MojoExecutionException("Error rendering velocity resource: " + source, (Exception)((Object)e2));
                    }
                    catch (ResourceNotFoundException e3) {
                        throw new MojoExecutionException("Error rendering velocity resource: " + source, (Exception)((Object)e3));
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    IOUtil.close((Reader)reader);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
            IOUtil.close((Reader)reader);
            this.fileWriteIfDiffers(os);
        } else if (resource.isFiltering()) {
            MavenFileFilterRequest req = this.setupRequest(resource, source, file);
            try {
                this.fileFilter.copyFile(req);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Error filtering resource: " + source, (Exception)((Object)e));
            }
        } else {
            FileUtils.copyFile((File)source, (File)file);
        }
        resource.addExclude(relFileName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileWriteIfDiffers(DeferredFileOutputStream outStream) throws IOException {
        File file = outStream.getFile();
        if (outStream.isThresholdExceeded()) {
            this.getLog().info((CharSequence)("File " + file + " was overwritten due to content limit threshold " + outStream.getThreshold() + " reached"));
            return;
        }
        boolean needOverwrite = true;
        if (file.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                ByteArrayInputStream newContents = new ByteArrayInputStream(outStream.getData());
                boolean bl = needOverwrite = !IOUtil.contentEquals((InputStream)is, (InputStream)newContents);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("File " + file + " contents " + (needOverwrite ? "differs" : "does not differ")));
                }
                ((InputStream)is).close();
                is = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
        if (!needOverwrite) {
            this.getLog().debug((CharSequence)("File " + file + " is up to date"));
            return;
        }
        this.getLog().debug((CharSequence)("Writing " + file));
        FileOutputStream os = new FileOutputStream(file);
        try {
            outStream.writeTo((OutputStream)os);
            ((OutputStream)os).close();
            os = null;
        }
        finally {
            IOUtil.close((OutputStream)os);
        }
    }

    private MavenFileFilterRequest setupRequest(Resource resource, File source, File file) {
        MavenFileFilterRequest req = new MavenFileFilterRequest();
        req.setFrom(source);
        req.setTo(file);
        req.setFiltering(resource.isFiltering());
        req.setMavenProject(this.project);
        req.setMavenSession(this.mavenSession);
        req.setInjectProjectBuildFilters(true);
        if (this.encoding != null) {
            req.setEncoding(this.encoding);
        }
        if (this.filterDelimiters != null && !this.filterDelimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (this.useDefaultFilterDelimiters) {
                delims.addAll(req.getDelimiters());
            }
            for (String delim : this.filterDelimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            req.setDelimiters(delims);
        }
        return req;
    }

    protected void validate() throws MojoExecutionException {
        int bundleCount = 1;
        for (String artifactDescriptor : this.resourceBundles) {
            String[] s = StringUtils.split((String)artifactDescriptor, (String)":");
            if (s.length < 3 || s.length > 5) {
                String position = bundleCount == 1 ? "1st" : (bundleCount == 2 ? "2nd" : (bundleCount == 3 ? "3rd" : bundleCount + "th"));
                throw new MojoExecutionException("The " + position + " resource bundle configured must specify a groupId, artifactId, " + " version and, optionally, type and classifier for a remote resource bundle. " + "Must be of the form <resourceBundle>groupId:artifactId:version</resourceBundle>, " + "<resourceBundle>groupId:artifactId:version:type</resourceBundle> or " + "<resourceBundle>groupId:artifactId:version:type:classifier</resourceBundle>");
            }
            ++bundleCount;
        }
    }

    protected VelocityContext buildVelocityContext(Map<String, Object> properties) throws MojoExecutionException {
        VelocityContext context = new VelocityContext(properties){

            public Object internalGet(String key) {
                Object result = super.internalGet(key);
                if (result == null && key != null && key.startsWith(ProcessRemoteResourcesMojo.KEY_PROJECTS) && this.containsKey(key)) {
                    List<MavenProject> projects = ProcessRemoteResourcesMojo.this.getProjects();
                    this.put(ProcessRemoteResourcesMojo.KEY_PROJECTS, projects);
                    this.put(ProcessRemoteResourcesMojo.KEY_PROJECTS_ORGS, ProcessRemoteResourcesMojo.this.getProjectsSortedByOrganization(projects));
                    return super.internalGet(key);
                }
                return result;
            }
        };
        context.put(KEY_PROJECTS, null);
        context.put(KEY_PROJECTS_ORGS, null);
        String inceptionYear = this.project.getInceptionYear();
        String year = new SimpleDateFormat("yyyy").format(new Date());
        if (StringUtils.isEmpty((String)inceptionYear)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("inceptionYear not specified, defaulting to " + year));
            }
            inceptionYear = year;
        }
        context.put("project", (Object)this.project);
        context.put("presentYear", (Object)year);
        context.put("locator", (Object)this.locator);
        if (inceptionYear.equals(year)) {
            context.put("projectTimespan", (Object)year);
        } else {
            context.put("projectTimespan", (Object)(inceptionYear + "-" + year));
        }
        return context;
    }

    private List<File> downloadBundles(List<String> bundles) throws MojoExecutionException {
        ArrayList<File> bundleArtifacts = new ArrayList<File>();
        try {
            for (String artifactDescriptor : bundles) {
                this.getLog().info((CharSequence)("Preparing remote bundle " + artifactDescriptor));
                String[] s = artifactDescriptor.split(":");
                File artifactFile = null;
                if (this.mavenSession != null) {
                    List list = this.mavenSession.getSortedProjects();
                    for (MavenProject p : list) {
                        if (!s[0].equals(p.getGroupId()) || !s[1].equals(p.getArtifactId()) || !s[2].equals(p.getVersion())) continue;
                        if (s.length >= 4 && "test-jar".equals(s[3])) {
                            artifactFile = new File(p.getBuild().getTestOutputDirectory());
                            continue;
                        }
                        artifactFile = new File(p.getBuild().getOutputDirectory());
                    }
                }
                if (artifactFile == null || !artifactFile.exists()) {
                    String type = s.length >= 4 ? s[3] : "jar";
                    String classifier = s.length == 5 ? s[4] : null;
                    Artifact artifact = this.artifactFactory.createDependencyArtifact(s[0], s[1], VersionRange.createFromVersion((String)s[2]), type, classifier, "runtime");
                    this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.localRepository);
                    artifactFile = artifact.getFile();
                }
                bundleArtifacts.add(artifactFile);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error downloading resources archive.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Resources archive cannot be found.", (Exception)((Object)e));
        }
        return bundleArtifacts;
    }

    private ClassLoader initalizeClassloader(List<File> artifacts) throws MojoExecutionException {
        RemoteResourcesClassLoader cl = new RemoteResourcesClassLoader(null);
        try {
            for (File artifact : artifacts) {
                cl.addURL(artifact.toURI().toURL());
            }
            return cl;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to configure resources classloader: " + e.getMessage(), (Exception)e);
        }
    }

    protected void processResourceBundles(ClassLoader classLoader, VelocityContext context) throws MojoExecutionException {
        ArrayList<AbstractMap.SimpleEntry<String, RemoteResourcesBundle>> remoteResources = new ArrayList<AbstractMap.SimpleEntry<String, RemoteResourcesBundle>>();
        int bundleCount = 0;
        int resourceCount = 0;
        InputStream in = null;
        try {
            RemoteResourcesBundleXpp3Reader bundleReader = new RemoteResourcesBundleXpp3Reader();
            Enumeration<URL> e = classLoader.getResources("META-INF/maven/remote-resources.xml");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                this.getLog().debug((CharSequence)("processResourceBundle on bundle#" + ++bundleCount + " " + url));
                in = url.openStream();
                RemoteResourcesBundle bundle = bundleReader.read(in);
                in.close();
                in = null;
                int n = 0;
                for (String bundleResource : bundle.getRemoteResources()) {
                    ++resourceCount;
                    this.getLog().debug((CharSequence)("bundle#" + bundleCount + " resource#" + ++n + " " + bundleResource));
                    remoteResources.add(new AbstractMap.SimpleEntry<String, RemoteResourcesBundle>(bundleResource, bundle));
                }
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error finding remote resources manifests", (Exception)ioe);
        }
        catch (XmlPullParserException xppe) {
            throw new MojoExecutionException("Error parsing remote resource bundle descriptor.", (Exception)((Object)xppe));
        }
        finally {
            IOUtil.close(in);
        }
        this.getLog().info((CharSequence)("Copying " + resourceCount + " resource" + (resourceCount > 1 ? "s" : "") + " from " + bundleCount + " bundle" + (bundleCount > 1 ? "s" : "") + "."));
        String velocityResource = null;
        FileOutputStream out = null;
        Writer writer = null;
        FileReader reader = null;
        try {
            for (Map.Entry entry : remoteResources) {
                String bundleResource;
                bundleResource = (String)entry.getKey();
                RemoteResourcesBundle bundle = (RemoteResourcesBundle)entry.getValue();
                String projectResource = bundleResource;
                boolean doVelocity = false;
                if (projectResource.endsWith(TEMPLATE_SUFFIX)) {
                    projectResource = projectResource.substring(0, projectResource.length() - 3);
                    velocityResource = bundleResource;
                    doVelocity = true;
                }
                File f = new File(this.outputDirectory, projectResource);
                FileUtils.mkdir((String)f.getParentFile().getAbsolutePath());
                if (this.copyResourceIfExists(f, projectResource, context)) continue;
                if (doVelocity) {
                    DeferredFileOutputStream os = new DeferredFileOutputStream(this.velocityFilterInMemoryThreshold, f);
                    Writer writer2 = writer = bundle.getSourceEncoding() == null ? new OutputStreamWriter((OutputStream)os) : new OutputStreamWriter((OutputStream)os, bundle.getSourceEncoding());
                    if (bundle.getSourceEncoding() == null) {
                        this.velocity.mergeTemplate(bundleResource, "ISO-8859-1", (Context)context, writer);
                    } else {
                        this.velocity.mergeTemplate(bundleResource, bundle.getSourceEncoding(), (Context)context, writer);
                    }
                    writer.close();
                    writer = null;
                    this.fileWriteIfDiffers(os);
                } else {
                    URL resUrl = classLoader.getResource(bundleResource);
                    if (resUrl != null) {
                        FileUtils.copyURLToFile((URL)resUrl, (File)f);
                    }
                }
                File appendedResourceFile = new File(this.appendedResourcesDirectory, projectResource);
                File appendedVmResourceFile = new File(this.appendedResourcesDirectory, projectResource + TEMPLATE_SUFFIX);
                if (appendedResourceFile.exists()) {
                    this.getLog().info((CharSequence)("Copying appended resource: " + projectResource));
                    in = new FileInputStream(appendedResourceFile);
                    out = new FileOutputStream(f, true);
                    IOUtil.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    out = null;
                    in.close();
                    in = null;
                    continue;
                }
                if (!appendedVmResourceFile.exists()) continue;
                this.getLog().info((CharSequence)("Filtering appended resource: " + projectResource + TEMPLATE_SUFFIX));
                reader = new FileReader(appendedVmResourceFile);
                writer = bundle.getSourceEncoding() == null ? new PrintWriter(new FileWriter(f, true)) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), bundle.getSourceEncoding()));
                Velocity.init();
                Velocity.evaluate((Context)context, (Writer)writer, (String)"remote-resources", (Reader)reader);
                writer.close();
                writer = null;
                ((Reader)reader).close();
                reader = null;
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading remote resource", (Exception)ioe);
        }
        catch (VelocityException e) {
            throw new MojoExecutionException("Error rendering Velocity resource '" + velocityResource + "'", (Exception)((Object)e));
        }
        finally {
            IOUtil.close(out);
            IOUtil.close((InputStream)in);
            IOUtil.close(writer);
            IOUtil.close(reader);
        }
    }

    protected Model getSupplement(Xpp3Dom supplementModelXml) throws MojoExecutionException {
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = modelReader.read((Reader)new StringReader(supplementModelXml.toString()));
            String groupId = model.getGroupId();
            String artifactId = model.getArtifactId();
            if (groupId == null || groupId.trim().equals("")) {
                throw new MojoExecutionException("Supplemental project XML requires that a <groupId> element be present.");
            }
            if (artifactId == null || artifactId.trim().equals("")) {
                throw new MojoExecutionException("Supplemental project XML requires that a <artifactId> element be present.");
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to read supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            this.getLog().warn((CharSequence)("Unable to parse supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        return model;
    }

    protected Model mergeModels(Model parent, Model child) {
        this.inheritanceAssembler.assembleModelInheritance(child, parent);
        return child;
    }

    private static String generateSupplementMapKey(String groupId, String artifactId) {
        return groupId.trim() + ":" + artifactId.trim();
    }

    private Map<String, Model> loadSupplements(String[] models) throws MojoExecutionException {
        if (models == null) {
            this.getLog().debug((CharSequence)"Supplemental data models won't be loaded.  No models specified.");
            return Collections.emptyMap();
        }
        ArrayList<Supplement> supplements = new ArrayList<Supplement>();
        for (String set : models) {
            this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
            try {
                File f = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                if (null == f || !f.exists()) {
                    throw new MojoExecutionException("Cold not resolve " + set);
                }
                if (!f.canRead()) {
                    throw new MojoExecutionException("Supplemental data models won't be loaded. File " + f.getAbsolutePath() + " cannot be read, check permissions on the file.");
                }
                this.getLog().debug((CharSequence)("Loading supplemental models from " + f.getAbsolutePath()));
                SupplementalDataModelXpp3Reader reader = new SupplementalDataModelXpp3Reader();
                SupplementalDataModel supplementalModel = reader.read(new FileReader(f));
                supplements.addAll(supplementalModel.getSupplement());
            }
            catch (Exception e) {
                String msg = "Error loading supplemental data models: " + e.getMessage();
                this.getLog().error((CharSequence)msg, (Throwable)e);
                throw new MojoExecutionException(msg, e);
            }
        }
        this.getLog().debug((CharSequence)"Loading supplements complete.");
        HashMap<String, Model> supplementMap = new HashMap<String, Model>();
        for (Supplement sd : supplements) {
            Xpp3Dom dom = (Xpp3Dom)sd.getProject();
            Model m = this.getSupplement(dom);
            supplementMap.put(ProcessRemoteResourcesMojo.generateSupplementMapKey(m.getGroupId(), m.getArtifactId()), m);
        }
        return supplementMap;
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    public void init(RuntimeServices rs) throws Exception {
    }

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.getLog().warn((CharSequence)message);
                break;
            }
            case 1: {
                this.getLog().debug((CharSequence)message);
                break;
            }
            case 0: {
                this.getLog().debug((CharSequence)message);
                break;
            }
            case 3: {
                this.getLog().error((CharSequence)message);
                break;
            }
            default: {
                this.getLog().debug((CharSequence)message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.getLog().warn((CharSequence)message, t);
                break;
            }
            case 1: {
                this.getLog().debug((CharSequence)message, t);
                break;
            }
            case 0: {
                this.getLog().debug((CharSequence)message, t);
                break;
            }
            case 3: {
                this.getLog().error((CharSequence)message, t);
                break;
            }
            default: {
                this.getLog().debug((CharSequence)message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        return false;
    }

    class ProjectComparator
    implements Comparator<MavenProject> {
        ProjectComparator() {
        }

        @Override
        public int compare(MavenProject p1, MavenProject p2) {
            return p1.getArtifact().compareTo((Object)p2.getArtifact());
        }

        public boolean equals(MavenProject p1, MavenProject p2) {
            return p1.getArtifact().equals(p2.getArtifact());
        }
    }

    class OrganizationComparator
    implements Comparator<Organization> {
        OrganizationComparator() {
        }

        @Override
        public int compare(Organization org1, Organization org2) {
            int i = this.compareStrings(org1.getName(), org2.getName());
            if (i == 0) {
                i = this.compareStrings(org1.getUrl(), org2.getUrl());
            }
            return i;
        }

        public boolean equals(Organization o1, Organization o2) {
            return this.compare(o1, o2) == 0;
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return 1;
            }
            if (s1 != null && s2 == null) {
                return -1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

