/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.projecthelp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public class DescribeMojo
extends AbstractMojo {
    private String plugin;
    private String groupId;
    private String artifactId;
    private String version;
    private String mojo;
    private PluginManager pluginManager;
    private MavenProject project;
    private Settings settings;
    private ArtifactRepository localRepository;
    private File output;

    public void execute() throws MojoExecutionException {
        PluginDescriptor descriptor;
        String pluginPrefix = null;
        if (this.plugin != null && this.plugin.length() > 0) {
            if (this.plugin.indexOf(":") > -1) {
                String[] pluginParts = this.plugin.split(":");
                switch (pluginParts.length) {
                    case 1: {
                        pluginPrefix = pluginParts[0];
                        break;
                    }
                    case 2: {
                        this.groupId = pluginParts[0];
                        this.artifactId = pluginParts[1];
                        break;
                    }
                    case 3: {
                        this.groupId = pluginParts[0];
                        this.artifactId = pluginParts[1];
                        this.version = pluginParts[2];
                        break;
                    }
                    default: {
                        throw new MojoExecutionException("plugin parameter must be a plugin prefix, or conform to: 'groupId:artifactId[:version].");
                    }
                }
            } else {
                pluginPrefix = this.plugin;
            }
        }
        if (pluginPrefix != null) {
            try {
                descriptor = this.pluginManager.getPluginDescriptorForPrefix(pluginPrefix);
            }
            catch (PluginManagerException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for prefix: '" + pluginPrefix + "'.", (Exception)((Object)e));
            }
        } else if (this.groupId != null && this.artifactId != null) {
            Plugin plugin = new Plugin();
            plugin.setGroupId(this.groupId);
            plugin.setArtifactId(this.artifactId);
            if (this.version != null) {
                plugin.setVersion(this.version);
            }
            try {
                descriptor = this.pluginManager.verifyPlugin(plugin, this.project, this.settings, this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginManagerException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginVersionResolutionException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
        } else {
            throw new MojoExecutionException("You must either specify 'groupId' and 'artifactId', or a valid 'plugin' parameter.");
        }
        StringBuffer descriptionBuffer = new StringBuffer();
        if (this.mojo != null && this.mojo.length() > 0) {
            this.describeMojo(descriptor.getMojo(this.mojo), descriptionBuffer);
        } else {
            this.describePlugin(descriptor, descriptionBuffer);
        }
        if (this.output != null) {
            FileWriter out = null;
            try {
                out = new FileWriter(this.output);
                out.write(descriptionBuffer.toString());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write plugin/mojo description.", (Exception)e);
            }
            finally {
                if (out != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)"Error closing file output.", (Throwable)e);
                    }
                }
            }
        }
        System.out.println(descriptionBuffer.toString());
    }

    private void describePlugin(PluginDescriptor pd, StringBuffer buffer) {
        buffer.append("Description of Plugin").append("\n-----------------------------------------------").append("\n\nGroup Id:  ").append(pd.getGroupId()).append("\nArtifact Id: ").append(pd.getArtifactId()).append("\nVersion:     ").append(pd.getVersion()).append("\nGoal Prefix: ").append(pd.getGoalPrefix()).append("\n\nMojos:").append("\n-----------------------------------------------").append("\n\n");
        Iterator it = pd.getMojos().iterator();
        while (it.hasNext()) {
            MojoDescriptor md = (MojoDescriptor)it.next();
            this.describeMojoGuts(md, buffer);
            buffer.append("\n-----------------------------------------------").append("\n\n");
        }
    }

    private void describeMojo(MojoDescriptor md, StringBuffer buffer) {
        buffer.append("Description of Mojo").append("\n-----------------------------------------------").append("\n\n");
        this.describeMojoGuts(md, buffer);
    }

    private void describeMojoGuts(MojoDescriptor md, StringBuffer buffer) {
        buffer.append("TODO!");
    }

    public final String getPlugin() {
        return this.plugin;
    }

    public final void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public final PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public final void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public final String getArtifactId() {
        return this.artifactId;
    }

    public final void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public final ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public final void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public final String getMojo() {
        return this.mojo;
    }

    public final void setMojo(String mojo) {
        this.mojo = mojo;
    }

    public final File getOutput() {
        return this.output;
    }

    public final void setOutput(File output) {
        this.output = output;
    }

    public final MavenProject getProject() {
        return this.project;
    }

    public final void setProject(MavenProject project) {
        this.project = project;
    }

    public final Settings getSettings() {
        return this.settings;
    }

    public final void setSettings(Settings settings) {
        this.settings = settings;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }
}

