/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-pmd-plugin:2.7.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven PMD Plugin", 0);
        this.append(sb, "A Maven plugin for the PMD toolkit, that produces a report on both code rule violations and detected copy and paste fragments, as well as being able to fail the build based on these metrics.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "pmd:check", 0);
            this.append(sb, "Fail the build if there were any PMD violations in the source code.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnViolation (Default: true)", 2);
                this.append(sb, "Whether to fail the build if the validation check fails.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${pmd.failOnViolation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failurePriority (Default: 5)", 2);
                this.append(sb, "What priority level to fail the build on. Failures at or above this level will stop the build. Anything below will be warnings and will be displayed in the build output if verbose=true. Note: Minimum Priority = 5 Maximum Priority = 0", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${pmd.failurePriority}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the PMD checks. Most useful on the command line via '-Dpmd.skip=true'.", 3);
                this.append(sb, "Expression: ${pmd.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetDirectory", 2);
                this.append(sb, "The location of the XML report to check, as generated by the PMD report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Print details of check failures to build output.", 3);
                this.append(sb, "Expression: ${pmd.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "cpd".equals(this.goal)) {
            this.append(sb, "pmd:cpd", 0);
            this.append(sb, "Creates a report for PMD's CPD tool. See http://pmd.sourceforge.net/cpd.html for more detail.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeRoots", 2);
                this.append(sb, "The project source directories that should be excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of files to exclude from checking. Can contain Ant-style wildcards and double wildcards. Note that these exclusion patterns only operate on the path of a source file relative to its source root directory. In other words, files are excluded based on their package and/or class name. If you want to exclude entire source root directories, use the parameter excludeRoots instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "format (Default: xml)", 2);
                this.append(sb, "Set the output format type, in addition to the HTML report. Must be one of: 'none', 'csv', 'xml', 'txt' or the full class name of the PMD renderer to use. See the net.sourceforge.pmd.renderers package javadoc for available renderers. XML is required if the pmd:check goal is being used.", 3);
                this.append(sb, "Expression: ${format}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreIdentifiers (Default: false)", 2);
                this.append(sb, "Similar to ignoreLiterals but for identifiers; i.e., variable names, methods names, and so forth.", 3);
                this.append(sb, "Expression: ${cpd.ignoreIdentifiers}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreLiterals (Default: false)", 2);
                this.append(sb, "If true, CPD ignores literal value differences when evaluating a duplicate block. This means that foo=42; and foo=43; will be seen as equivalent. You may want to run PMD with this option off to start with and then switch it on to see what it turns up.", 3);
                this.append(sb, "Expression: ${cpd.ignoreLiterals}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of files to include from checking. Can contain Ant-style wildcards and double wildcards. Defaults to **\\/*.java.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTests (Default: false)", 2);
                this.append(sb, "Run PMD on the tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Link the violation line numbers to the source xref. Links will be created automatically if the jxr plugin is being used.", 3);
                this.append(sb, "Expression: ${linkXRef}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minimumTokens (Default: 100)", 2);
                this.append(sb, "The minimum number of tokens that need to be duplicated before it causes a violation.", 3);
                this.append(sb, "Expression: ${minimumTokens}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory for the final HTML report. Note that this parameter is only evaluated if the goal is run directly from the command line or during the default lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.reporting.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "The file encoding when writing non-HTML reports.", 3);
                this.append(sb, "Expression: ${outputEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the CPD report generation. Most useful on the command line via '-Dcpd.skip=true'.", 3);
                this.append(sb, "Expression: ${cpd.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding to use when reading the Java sources.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetDirectory", 2);
                this.append(sb, "The output directory for the intermediate XML report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2);
                this.append(sb, "Location of the Xrefs to link to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Test Xrefs to link to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "cpd-check".equals(this.goal)) {
            this.append(sb, "pmd:cpd-check", 0);
            this.append(sb, "Fail the build if there were any CPD violations in the source code.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnViolation (Default: true)", 2);
                this.append(sb, "Whether to fail the build if the validation check fails.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${pmd.failOnViolation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the CPD violation checks. Most useful on the command line via '-Dcpd.skip=true'.", 3);
                this.append(sb, "Expression: ${cpd.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetDirectory", 2);
                this.append(sb, "The location of the XML report to check, as generated by the PMD report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Print details of check failures to build output.", 3);
                this.append(sb, "Expression: ${pmd.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "pmd:help", 0);
            this.append(sb, "Display help information on maven-pmd-plugin.\nCall\n\u00a0\u00a0mvn\u00a0pmd:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pmd".equals(this.goal)) {
            this.append(sb, "pmd:pmd", 0);
            this.append(sb, "Creates a PMD report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "aggregate (Default: false)", 2);
                this.append(sb, "Whether to build an aggregated report at the root, or build individual reports.", 3);
                this.append(sb, "Expression: ${aggregate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeRoots", 2);
                this.append(sb, "The project source directories that should be excluded.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of files to exclude from checking. Can contain Ant-style wildcards and double wildcards. Note that these exclusion patterns only operate on the path of a source file relative to its source root directory. In other words, files are excluded based on their package and/or class name. If you want to exclude entire source root directories, use the parameter excludeRoots instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "format (Default: xml)", 2);
                this.append(sb, "Set the output format type, in addition to the HTML report. Must be one of: 'none', 'csv', 'xml', 'txt' or the full class name of the PMD renderer to use. See the net.sourceforge.pmd.renderers package javadoc for available renderers. XML is required if the pmd:check goal is being used.", 3);
                this.append(sb, "Expression: ${format}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of files to include from checking. Can contain Ant-style wildcards and double wildcards. Defaults to **\\/*.java.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTests (Default: false)", 2);
                this.append(sb, "Run PMD on the tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Link the violation line numbers to the source xref. Links will be created automatically if the jxr plugin is being used.", 3);
                this.append(sb, "Expression: ${linkXRef}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minimumPriority (Default: 5)", 2);
                this.append(sb, "The rule priority threshold; rules with lower priority than this will not be evaluated.", 3);
                this.append(sb, "Expression: ${minimumPriority}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory for the final HTML report. Note that this parameter is only evaluated if the goal is run directly from the command line or during the default lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.reporting.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "The file encoding when writing non-HTML reports.", 3);
                this.append(sb, "Expression: ${outputEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "rulesets", 2);
                this.append(sb, "The PMD rulesets to use. See the Stock Rulesets for a list of some included. Since version 2.5, the ruleset 'rulesets/maven.xml' is also available. Defaults to the basic, imports and unusedcode rulesets.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the PMD report generation. Most useful on the command line via '-Dpmd.skip=true'.", 3);
                this.append(sb, "Expression: ${pmd.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding to use when reading the Java sources.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetDirectory", 2);
                this.append(sb, "The output directory for the intermediate XML report.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetJdk", 2);
                this.append(sb, "The target JDK to analyze based on. Should match the target used in the compiler plugin. Valid values are currently 1.3, 1.4, 1.5 and 1.6.\nNote: support for 1.6 was added in version 2.3 of this plugin.\n", 3);
                this.append(sb, "Expression: ${targetJdk}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2);
                this.append(sb, "Location of the Xrefs to link to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2);
                this.append(sb, "Location of the Test Xrefs to link to.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

