/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.repository.Repository;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JxrReportUtil {
    protected static String getMavenJavadocPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        ArrayList plugins = new ArrayList();
        Iterator it = project.getModel().getReporting().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        String pluginArtifactId = "maven-javadoc-plugin";
        Iterator it2 = plugins.iterator();
        while (it2.hasNext()) {
            Object next = it2.next();
            Xpp3Dom pluginConf = null;
            if (next instanceof Plugin) {
                Plugin plugin = (Plugin)next;
                if (!plugin.getGroupId().equals("org.apache.maven.plugins") || !plugin.getArtifactId().equals(pluginArtifactId)) continue;
                pluginConf = (Xpp3Dom)plugin.getConfiguration();
            }
            if (next instanceof ReportPlugin) {
                ReportPlugin reportPlugin = (ReportPlugin)next;
                if (!reportPlugin.getGroupId().equals("org.apache.maven.plugins") || !reportPlugin.getArtifactId().equals(pluginArtifactId)) continue;
                pluginConf = (Xpp3Dom)reportPlugin.getConfiguration();
            }
            if (pluginConf == null) continue;
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)new StringInputStream(pluginConf.toString()));
                XObject obj = XPathAPI.eval((Node)doc, (String)("//configuration/" + optionName));
                if (!StringUtils.isNotEmpty((String)obj.toString())) continue;
                return obj.toString();
            }
            catch (SAXException e) {
                throw new IOException("SAXException: " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IOException("ParserConfigurationException: " + e.getMessage());
            }
            catch (FactoryConfigurationError e) {
                throw new IOException("FactoryConfigurationError: " + e.getMessage());
            }
            catch (TransformerException e) {
                throw new IOException("TransformerException: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    protected static String getStructure(MavenProject project, boolean ignoreMissingSiteUrl) throws IOException {
        if (project.getDistributionManagement() == null) {
            String hierarchy = project.getName();
            for (MavenProject parent = project.getParent(); parent != null; parent = parent.getParent()) {
                hierarchy = parent.getName() + "/" + hierarchy;
            }
            return hierarchy;
        }
        Site site = project.getDistributionManagement().getSite();
        if (site == null) {
            if (!ignoreMissingSiteUrl) {
                throw new IOException("Missing site information in the distribution management element in the project: '" + project.getName() + "'.");
            }
            return null;
        }
        if (StringUtils.isEmpty((String)site.getUrl())) {
            if (!ignoreMissingSiteUrl) {
                throw new IOException("The URL in the site is missing in the project descriptor.");
            }
            return null;
        }
        Repository repository = new Repository(site.getId(), site.getUrl());
        if (StringUtils.isEmpty((String)repository.getBasedir())) {
            return repository.getHost();
        }
        if (repository.getBasedir().startsWith("/")) {
            return repository.getHost() + repository.getBasedir();
        }
        return repository.getHost() + "/" + repository.getBasedir();
    }
}

