/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ejb;

import com.google.inject.internal.util.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.ejb.EjbHelper;
import org.apache.maven.plugins.ejb.IncludesExcludes;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="ejb", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class EjbMojo
extends AbstractMojo {
    private static final List<String> DEFAULT_INCLUDES_LIST = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"**/**"}));
    private static final List<String> DEFAULT_CLIENT_EXCLUDES_LIST = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"**/*Bean.class", "**/*CMP.class", "**/*Session.class", "**/package.html"}));
    public static final String DEFAULT_CLIENT_CLASSIFIER = "client";
    public static final String DEFAULT_EJBJAR = "META-INF/ejb-jar.xml";
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String jarName;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="client")
    private String clientClassifier;
    @Parameter(defaultValue="META-INF/ejb-jar.xml")
    private String ejbJar;
    @Parameter(defaultValue="false")
    private boolean generateClient;
    @Parameter
    private List<String> clientExcludes;
    @Parameter
    private List<String> clientIncludes;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(defaultValue="3.1")
    private String ejbVersion;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver clientJarArchiver;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="false")
    private boolean escapeBackslashesInFilePath;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    private boolean filterDeploymentDescriptor;
    @Parameter
    private List<String> filters;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private static final String EJB_TYPE = "ejb";
    private static final String EJB_CLIENT_TYPE = "ejb-client";

    public void execute() throws MojoExecutionException {
        if (!this.sourceDirectory.exists()) {
            this.getLog().warn((CharSequence)("The created EJB jar will be empty cause the " + this.sourceDirectory.getPath() + " did not exist."));
            this.sourceDirectory.mkdirs();
        }
        File jarFile = this.generateEjb();
        if (this.hasClassifier()) {
            if (!this.isClassifierValid()) {
                String message = "The given classifier '" + this.getClassifier() + "' is not valid.";
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message);
            }
            this.projectHelper.attachArtifact(this.project, EJB_TYPE, this.getClassifier(), jarFile);
        } else {
            if (this.projectHasAlreadySetAnArtifact()) {
                throw new MojoExecutionException("You have to use a classifier to attach supplemental artifacts to the project instead of replacing them.");
            }
            this.project.getArtifact().setFile(jarFile);
        }
        if (this.generateClient) {
            File clientJarFile = this.generateEjbClient();
            if (this.hasClientClassifier()) {
                if (!this.isClientClassifierValid()) {
                    String message = "The given client classifier '" + this.getClientClassifier() + "' is not valid.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
                this.projectHelper.attachArtifact(this.project, EJB_CLIENT_TYPE, this.getClientClassifier(), clientJarFile);
            } else {
                this.projectHelper.attachArtifact(this.project, EJB_CLIENT_TYPE, this.getClientClassifier(), clientJarFile);
            }
        }
    }

    private boolean projectHasAlreadySetAnArtifact() {
        if (this.getProject().getArtifact().getFile() != null) {
            return this.getProject().getArtifact().getFile().isFile();
        }
        return false;
    }

    private File generateEjb() throws MojoExecutionException {
        File jarFile = EjbHelper.getJarFile(this.outputDirectory, this.jarName, this.getClassifier());
        this.getLog().info((CharSequence)("Building EJB " + this.jarName + " with EJB version " + this.ejbVersion));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        File deploymentDescriptor = new File(this.sourceDirectory, this.ejbJar);
        this.checkEJBVersionCompliance(deploymentDescriptor);
        try {
            ArrayList defaultExcludes = Lists.newArrayList((Object[])new String[]{this.ejbJar, "**/package.html"});
            List<String> defaultIncludes = DEFAULT_INCLUDES_LIST;
            IncludesExcludes ie = new IncludesExcludes(Collections.emptyList(), this.excludes, defaultIncludes, defaultExcludes);
            archiver.getArchiver().addDirectory(this.sourceDirectory, ie.resultingIncludes(), ie.resultingExcludes());
            if (deploymentDescriptor.exists()) {
                if (this.filterDeploymentDescriptor) {
                    this.filterDeploymentDescriptor(deploymentDescriptor);
                }
                archiver.getArchiver().addFile(deploymentDescriptor, this.ejbJar);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem creating the EJB archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("There was a problem filtering the deployment descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        return jarFile;
    }

    private File generateEjbClient() throws MojoExecutionException {
        File clientJarFile = EjbHelper.getJarFile(this.outputDirectory, this.jarName, this.getClientClassifier());
        this.getLog().info((CharSequence)("Building EJB client " + clientJarFile.getPath()));
        MavenArchiver clientArchiver = new MavenArchiver();
        clientArchiver.setArchiver(this.clientJarArchiver);
        clientArchiver.setOutputFile(clientJarFile);
        try {
            List<String> defaultExcludes = DEFAULT_CLIENT_EXCLUDES_LIST;
            List<String> defaultIncludes = DEFAULT_INCLUDES_LIST;
            IncludesExcludes ie = new IncludesExcludes(this.clientIncludes, this.clientExcludes, defaultIncludes, defaultExcludes);
            clientArchiver.getArchiver().addDirectory(this.sourceDirectory, ie.resultingIncludes(), ie.resultingExcludes());
            clientArchiver.createArchive(this.session, this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem creating the EJB client archive: " + e.getMessage(), (Exception)((Object)e));
        }
        return clientJarFile;
    }

    private void checkEJBVersionCompliance(File deploymentDescriptor) throws MojoExecutionException {
        if (!this.ejbVersion.matches("\\A[2-3]\\.[0-9]\\z")) {
            throw new MojoExecutionException("ejbVersion is not valid: " + this.ejbVersion + ". Must be 2.x or 3.x (where x is a digit)");
        }
        if (this.ejbVersion.matches("\\A2\\.[0-9]\\z") && !deploymentDescriptor.exists()) {
            throw new MojoExecutionException("Error assembling EJB: " + this.ejbJar + " is required for ejbVersion 2.x");
        }
    }

    private void filterDeploymentDescriptor(File deploymentDescriptor) throws MavenFilteringException, IOException {
        this.getLog().debug((CharSequence)"Filtering deployment descriptor.");
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
        mavenResourcesExecution.setEscapeString(this.escapeString);
        List filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapeBackslashesInFilePath, this.session, mavenResourcesExecution);
        File unfilteredDeploymentDescriptor = new File(this.sourceDirectory, this.ejbJar + ".unfiltered");
        FileUtils.copyFile((File)deploymentDescriptor, (File)unfilteredDeploymentDescriptor);
        this.mavenFileFilter.copyFile(unfilteredDeploymentDescriptor, deploymentDescriptor, true, filterWrappers, this.getEncoding(unfilteredDeploymentDescriptor));
        FileUtils.forceDelete((File)unfilteredDeploymentDescriptor);
    }

    private boolean hasClassifier() {
        return EjbHelper.hasClassifier(this.getClassifier());
    }

    private boolean hasClientClassifier() {
        return EjbHelper.hasClassifier(this.getClientClassifier());
    }

    private boolean isClassifierValid() {
        return EjbHelper.isClassifierValid(this.getClassifier());
    }

    private boolean isClientClassifierValid() {
        return EjbHelper.isClassifierValid(this.getClientClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncoding(File xmlFile) throws IOException {
        String string;
        XmlStreamReader xmlReader = null;
        try {
            xmlReader = new XmlStreamReader(xmlFile);
            String encoding = xmlReader.getEncoding();
            xmlReader.close();
            xmlReader = null;
            string = encoding;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xmlReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)xmlReader);
        return string;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getClientClassifier() {
        return this.clientClassifier;
    }

    public MavenProject getProject() {
        return this.project;
    }
}

