/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.Writer;
import org.apache.maven.plugin.ear.AbstractXmlWriter;
import org.apache.maven.plugin.ear.ApplicationXmlWriterContext;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.EjbRef;
import org.apache.maven.plugin.ear.EnvEntry;
import org.apache.maven.plugin.ear.SecurityRole;
import org.apache.maven.plugin.ear.util.JavaEEVersion;
import org.codehaus.plexus.util.xml.XMLWriter;

final class ApplicationXmlWriter
extends AbstractXmlWriter {
    public static final String DOCTYPE_1_3 = "application PUBLIC\n\t\"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\"\n\t\"http://java.sun.com/dtd/application_1_3.dtd\"";
    private static final String APPLICATION_ELEMENT = "application";
    private final JavaEEVersion version;
    private final Boolean generateModuleId;

    ApplicationXmlWriter(JavaEEVersion version, String encoding, Boolean generateModuleId) {
        super(encoding);
        this.version = version;
        this.generateModuleId = generateModuleId;
    }

    public void write(ApplicationXmlWriterContext context) throws EarPluginException {
        Writer w = this.initializeWriter(context.getDestinationFile());
        XMLWriter writer = null;
        if (JavaEEVersion.ONE_DOT_THREE.eq(this.version)) {
            writer = this.initializeRootElementOneDotThree(w);
        } else if (JavaEEVersion.ONE_DOT_FOUR.eq(this.version)) {
            writer = this.initializeRootElementOneDotFour(w);
        } else if (JavaEEVersion.FIVE.eq(this.version)) {
            writer = this.initializeRootElementFive(w);
        } else if (JavaEEVersion.SIX.eq(this.version)) {
            writer = this.initializeRootElementSix(w);
        } else if (JavaEEVersion.SEVEN.eq(this.version)) {
            writer = this.initializeRootElementSeven(w);
        }
        if (context.getApplicationId() != null) {
            writer.addAttribute("id", context.getApplicationId());
        }
        if (this.version.ge(JavaEEVersion.SIX)) {
            this.writeApplicationName(context.getApplicationName(), writer);
        }
        if (this.version.eq(JavaEEVersion.ONE_DOT_THREE)) {
            this.writeDisplayName(context.getDisplayName(), writer);
            this.writeDescription(context.getDescription(), writer);
        } else {
            this.writeDescription(context.getDescription(), writer);
            this.writeDisplayName(context.getDisplayName(), writer);
        }
        if (this.version.ge(JavaEEVersion.SIX)) {
            this.writeInitializeInOrder(context.getInitializeInOrder(), writer);
        }
        for (EarModule module : context.getEarModules()) {
            module.appendModule(writer, this.version.getVersion(), this.generateModuleId);
        }
        for (SecurityRole securityRole : context.getSecurityRoles()) {
            securityRole.appendSecurityRole(writer);
        }
        if (this.version.ge(JavaEEVersion.FIVE)) {
            this.writeLibraryDirectory(context.getLibraryDirectory(), writer);
        }
        if (this.version.ge(JavaEEVersion.SIX)) {
            for (EnvEntry envEntry : context.getEnvEntries()) {
                envEntry.appendEnvEntry(writer);
            }
            for (EjbRef ejbEntry : context.getEjbEntries()) {
                ejbEntry.appendEjbRefEntry(writer);
            }
        }
        writer.endElement();
        this.close(w);
    }

    private void writeApplicationName(String applicationName, XMLWriter writer) {
        if (applicationName != null) {
            writer.startElement("application-name");
            writer.writeText(applicationName);
            writer.endElement();
        }
    }

    private void writeDescription(String description, XMLWriter writer) {
        if (description != null) {
            writer.startElement("description");
            writer.writeText(description);
            writer.endElement();
        }
    }

    private void writeDisplayName(String displayName, XMLWriter writer) {
        if (displayName != null) {
            writer.startElement("display-name");
            writer.writeText(displayName);
            writer.endElement();
        }
    }

    private void writeInitializeInOrder(Boolean initializeInOrder, XMLWriter writer) {
        if (initializeInOrder != null) {
            writer.startElement("initialize-in-order");
            writer.writeText(initializeInOrder.toString());
            writer.endElement();
        }
    }

    private void writeLibraryDirectory(String libraryDirectory, XMLWriter writer) {
        if (libraryDirectory != null) {
            writer.startElement("library-directory");
            writer.writeText(libraryDirectory);
            writer.endElement();
        }
    }

    private XMLWriter initializeRootElementOneDotThree(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, DOCTYPE_1_3);
        writer.startElement(APPLICATION_ELEMENT);
        return writer;
    }

    private XMLWriter initializeRootElementOneDotFour(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        writer.addAttribute("version", "1.4");
        return writer;
    }

    private XMLWriter initializeRootElementFive(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/javaee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd");
        writer.addAttribute("version", "5");
        return writer;
    }

    private XMLWriter initializeRootElementSix(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/javaee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_6.xsd");
        writer.addAttribute("version", "6");
        return writer;
    }

    private XMLWriter initializeRootElementSeven(Writer w) {
        XMLWriter writer = this.initializeXmlWriter(w, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://xmlns.jcp.org/xml/ns/javaee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/application_7.xsd");
        writer.addAttribute("version", "7");
        return writer;
    }
}

