/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.codehaus.plexus.util.StringUtils;

public class CheckstyleReportListener
extends AutomaticBean
implements AuditListener {
    private List sourceDirectories = new ArrayList();
    private CheckstyleResults results;
    private String currentFile;
    private List events;
    private SeverityLevel severityLevel;
    private Configuration checkstyleConfiguration;

    public CheckstyleReportListener(File sourceDirectory) {
        this.sourceDirectories.add(sourceDirectory);
    }

    public CheckstyleReportListener(File sourceDirectory, Configuration configuration) {
        this.sourceDirectories.add(sourceDirectory);
        this.checkstyleConfiguration = configuration;
    }

    public void addSourceDirectory(File sourceDirectory) {
        this.sourceDirectories.add(sourceDirectory);
    }

    public void setSeverityLevelFilter(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
    }

    public SeverityLevel getSeverityLevelFilter() {
        return this.severityLevel;
    }

    public void auditStarted(AuditEvent event) {
        this.setResults(new CheckstyleResults());
    }

    public void auditFinished(AuditEvent event) {
    }

    public void fileStarted(AuditEvent event) {
        for (File sourceDirectory : this.sourceDirectories) {
            this.currentFile = StringUtils.substring((String)event.getFileName(), (int)(sourceDirectory.getPath().length() + 1));
            this.currentFile = StringUtils.replace((String)this.currentFile, (String)"\\", (String)"/");
            this.events = this.getResults().getFileViolations(this.currentFile);
        }
        if (this.events == null) {
            this.events = new ArrayList();
        }
    }

    public void fileFinished(AuditEvent event) {
        this.getResults().setFileViolations(this.currentFile, this.events);
        this.currentFile = null;
    }

    public void addError(AuditEvent event) {
        if (SeverityLevel.IGNORE.equals((Object)event.getSeverityLevel())) {
            return;
        }
        if (this.severityLevel == null || this.severityLevel.equals((Object)event.getSeverityLevel())) {
            this.events.add(event);
        }
    }

    public void addException(AuditEvent event, Throwable throwable) {
    }

    public CheckstyleResults getResults() {
        this.results.setConfiguration(this.checkstyleConfiguration);
        return this.results;
    }

    public void setResults(CheckstyleResults results) {
        this.results = results;
    }

    public Configuration getCheckstyleConfiguration() {
        return this.checkstyleConfiguration;
    }

    public void setCheckstyleConfiguration(Configuration checkstyleConfiguration) {
        this.checkstyleConfiguration = checkstyleConfiguration;
    }
}

