/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.javadoc;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMojoTaglet
implements Taglet {
    public String toString(Tag tag) {
        if (tag == null) {
            return null;
        }
        String tagValue = this.getTagValue(tag);
        MutableAttributeSet tagAttributes = this.getTagAttributes(tag);
        StringBuilder sb = new StringBuilder();
        this.appendTag(sb, tag, tagAttributes, tagValue);
        return sb.toString();
    }

    public String toString(Tag[] tags) {
        if (tags.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.length; ++i) {
            String tagValue = this.getTagValue(tags[i]);
            MutableAttributeSet tagAttributes = this.getTagAttributes(tags[i]);
            this.appendTag(sb, tags[i], tagAttributes, tagValue);
        }
        return sb.toString();
    }

    public abstract String getHeader();

    public abstract String getAllowedValue();

    public abstract String[] getAllowedParameterNames();

    public boolean hasAnnotationValue() {
        return this.getAllowedValue() != null;
    }

    public boolean hasAnnotationParameters() {
        return this.getAllowedParameterNames() != null;
    }

    private String getTagValue(Tag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag should be not null");
        }
        String text = tag.text();
        if (AbstractMojoTaglet.isEmpty(text)) {
            return null;
        }
        String tagValue = null;
        StringTokenizer token = new StringTokenizer(text, " ");
        while (token.hasMoreTokens()) {
            String nextToken = token.nextToken();
            if (nextToken.indexOf(61) != -1) continue;
            tagValue = nextToken;
        }
        return tagValue;
    }

    private MutableAttributeSet getTagAttributes(Tag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag should be not null");
        }
        String text = tag.text();
        StringTokenizer token = new StringTokenizer(text, " ");
        SimpleAttributeSet tagAttributes = new SimpleAttributeSet();
        while (token.hasMoreTokens()) {
            String nextToken = token.nextToken();
            if (nextToken.indexOf(61) == -1) continue;
            StringTokenizer token2 = new StringTokenizer(nextToken, "=");
            if (token2.countTokens() != 2) {
                System.err.println("The annotation '" + tag.name() + "' has no name/value pairs parameter: " + tag.name() + " " + text + " (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                tagAttributes.addAttribute(token2.nextToken(), "");
                continue;
            }
            String name = token2.nextToken();
            String value = token2.nextToken().replaceAll("\"", "");
            if (this.getAllowedParameterNames() != null && !Arrays.asList(this.getAllowedParameterNames()).contains(name)) {
                System.err.println("The annotation '" + tag.name() + "' has wrong parameter name: " + tag.name() + " " + text + " (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
            }
            tagAttributes.addAttribute(name, value);
        }
        return tagAttributes;
    }

    private void appendTag(StringBuilder sb, Tag tag, MutableAttributeSet tagAttributes, String tagValue) {
        if (!this.hasAnnotationParameters()) {
            if (tagAttributes.getAttributeCount() > 0) {
                System.err.println("The annotation '@" + this.getName() + "' should have no attribute (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
            }
            if (this.hasAnnotationValue()) {
                sb.append("<DT><B>").append(this.getHeader()).append(":</B></DT>");
                if (AbstractMojoTaglet.isEveryValues(this.getAllowedValue())) {
                    if (AbstractMojoTaglet.isNotEmpty(tagValue)) {
                        sb.append("<DD>").append(tagValue).append("</DD>");
                    } else {
                        System.err.println("The annotation '@" + this.getName() + "' is specified to have a value but " + "no value is defined (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                        sb.append("<DD>").append("NOT DEFINED").append("</DD>");
                    }
                } else {
                    List<String> l = AbstractMojoTaglet.getOnlyValues(this.getAllowedValue());
                    if (AbstractMojoTaglet.isNotEmpty(tagValue)) {
                        if (l.contains(tagValue)) {
                            sb.append("<DD>").append(tagValue).append("</DD>");
                        } else {
                            System.err.println("The annotation '@" + this.getName() + "' is specified to be a value of " + l + " (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                            sb.append("<DD>").append(tagValue).append("</DD>");
                        }
                    } else {
                        sb.append("<DD>").append(l.get(0)).append("</DD>");
                    }
                }
            } else {
                if (AbstractMojoTaglet.isNotEmpty(tagValue)) {
                    System.err.println("The annotation '@" + this.getName() + "' should have no value (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                }
                sb.append("<DT><B>").append(this.getHeader()).append("</B></DT>");
                sb.append("<DD></DD>");
            }
        } else {
            if (this.hasAnnotationValue()) {
                sb.append("<DT><B>").append(this.getHeader()).append(":</B></DT>");
                if (AbstractMojoTaglet.isEveryValues(this.getAllowedValue())) {
                    if (AbstractMojoTaglet.isNotEmpty(tagValue)) {
                        sb.append("<DD>").append(tagValue);
                    } else {
                        System.err.println("The annotation '@" + this.getName() + "' is specified to have a value but " + "no value is defined (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                        sb.append("<DD>").append("NOT DEFINED");
                    }
                } else {
                    List<String> l = AbstractMojoTaglet.getOnlyValues(this.getAllowedValue());
                    if (AbstractMojoTaglet.isNotEmpty(tagValue)) {
                        if (l.contains(tagValue)) {
                            sb.append("<DD>").append(tagValue);
                        } else {
                            System.err.println("The annotation '@" + this.getName() + "' is specified to be a value in " + l + " (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                            sb.append("<DD>").append(tagValue);
                        }
                    } else {
                        sb.append("<DD>").append(l.get(0));
                    }
                }
            } else {
                if (AbstractMojoTaglet.isNotEmpty(tagValue)) {
                    System.err.println("The annotation '@" + this.getName() + "' should have no value (" + tag.position().file() + ":" + tag.position().line() + ":" + tag.position().column() + ")");
                }
                sb.append("<DT><B>").append(this.getHeader()).append(":</B></DT>");
                sb.append("<DD>");
            }
            AbstractMojoTaglet.appendAnnotationParameters(sb, tagAttributes);
            sb.append("</DD>");
        }
    }

    private static void appendAnnotationParameters(StringBuilder sb, MutableAttributeSet att) {
        sb.append("<DL>");
        Enumeration<?> names = att.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = att.getAttribute(key);
            if (value instanceof AttributeSet) continue;
            sb.append("<DT><B>").append(key).append(":</B></DT>");
            sb.append("<DD>").append(value).append("</DD>");
        }
        sb.append("</DL>");
    }

    private static boolean isEveryValues(String text) {
        return text.trim().equals("*");
    }

    private static List<String> getOnlyValues(String text) {
        if (text.indexOf(124) == -1) {
            return Collections.emptyList();
        }
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(text, "|");
        while (token.hasMoreTokens()) {
            l.add(token.nextToken());
        }
        return l;
    }

    private static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

