/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;

public class PluginHelpGenerator
extends AbstractLogEnabled
implements Generator {
    private static final String HELP_MOJO_CLASS_NAME = "HelpMojo";
    private static final String HELP_PROPERTIES_FILENAME = "maven-plugin-help.properties";
    private static final String HELP_GOAL = "help";
    private String helpPackageName;
    private VelocityComponent velocityComponent;

    public PluginHelpGenerator() {
        this.enableLogging((Logger)new ConsoleLogger(1, "PluginHelpGenerator"));
    }

    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        MojoDescriptor descriptor;
        PluginDescriptor pluginDescriptor = request.getPluginDescriptor();
        String helpImplementation = this.getImplementation(pluginDescriptor);
        List mojoDescriptors = pluginDescriptor.getMojos();
        if (mojoDescriptors != null && (descriptor = pluginDescriptor.getMojo(HELP_GOAL)) != null && !descriptor.getImplementation().equals(helpImplementation)) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("\n\nA help goal (" + descriptor.getImplementation() + ") already exists in this plugin. SKIPPED THE " + helpImplementation + " GENERATION.\n");
            }
            return;
        }
        this.writeHelpPropertiesFile(request);
        try {
            String sourcePath = helpImplementation.replace('.', File.separatorChar) + ".java";
            File helpClass = new File(destinationDirectory, sourcePath);
            helpClass.getParentFile().mkdirs();
            MavenProject mavenProject = request.getProject();
            String pluginResourcesPath = "META-INF/maven/" + mavenProject.getGroupId() + "/" + mavenProject.getArtifactId();
            String helpClassSources = this.getHelpClassSources(pluginResourcesPath, pluginDescriptor);
            FileUtils.fileWrite((File)helpClass, (String)request.getEncoding(), (String)helpClassSources);
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    public PluginHelpGenerator setHelpPackageName(String helpPackageName) {
        this.helpPackageName = helpPackageName;
        return this;
    }

    public VelocityComponent getVelocityComponent() {
        return this.velocityComponent;
    }

    public PluginHelpGenerator setVelocityComponent(VelocityComponent velocityComponent) {
        this.velocityComponent = velocityComponent;
        return this;
    }

    private String getHelpClassSources(String pluginResourcesPath, PluginDescriptor pluginDescriptor) {
        Properties properties = new Properties();
        VelocityContext context = new VelocityContext((Map)properties);
        if (this.helpPackageName != null) {
            properties.put("helpPackageName", this.helpPackageName);
        } else {
            properties.put("helpPackageName", "");
        }
        properties.put("pluginHelpPath", pluginResourcesPath + "/plugin-help.xml");
        properties.put("artifactId", pluginDescriptor.getArtifactId());
        properties.put("goalPrefix", pluginDescriptor.getGoalPrefix());
        StringWriter stringWriter = new StringWriter();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("help-class-source.vm");
        InputStreamReader isReader = new InputStreamReader(is);
        this.velocityComponent.getEngine().evaluate((Context)context, (Writer)stringWriter, "", (Reader)isReader);
        return stringWriter.toString();
    }

    private String getImplementation(PluginDescriptor pluginDescriptor) {
        String packageName = this.helpPackageName;
        if (StringUtils.isEmpty((String)packageName)) {
            packageName = GeneratorUtils.discoverPackageName(pluginDescriptor);
        }
        return StringUtils.isEmpty((String)packageName) ? HELP_MOJO_CLASS_NAME : packageName + '.' + HELP_MOJO_CLASS_NAME;
    }

    private void writeHelpPropertiesFile(PluginToolsRequest request) throws GeneratorException {
        Properties properties = new Properties();
        properties.put("helpPackageName", this.helpPackageName == null ? "" : this.helpPackageName);
        File tmpPropertiesFile = new File(request.getProject().getBuild().getDirectory(), HELP_PROPERTIES_FILENAME);
        if (tmpPropertiesFile.exists()) {
            tmpPropertiesFile.delete();
        } else if (!tmpPropertiesFile.getParentFile().exists()) {
            tmpPropertiesFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tmpPropertiesFile);
            properties.store(fos, "maven plugin help mojo generation informations");
        }
        catch (IOException e) {
            try {
                throw new GeneratorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)fos);
    }

    static void rewriteHelpMojo(PluginToolsRequest request) throws GeneratorException {
        String helpMojoImplementation;
        File tmpPropertiesFile = new File(request.getProject().getBuild().getDirectory(), HELP_PROPERTIES_FILENAME);
        if (!tmpPropertiesFile.exists()) {
            return;
        }
        Properties properties = PropertyUtils.loadProperties((File)tmpPropertiesFile);
        String helpPackageName = properties.getProperty("helpPackageName");
        if (StringUtils.isEmpty((String)helpPackageName) && (helpMojoImplementation = PluginHelpGenerator.rewriteHelpClassToMojoPackage(request)) != null) {
            PluginHelpGenerator.updateHelpMojoDescriptor(request.getPluginDescriptor(), helpMojoImplementation);
        }
    }

    private static String rewriteHelpClassToMojoPackage(PluginToolsRequest request) throws GeneratorException {
        String destinationPackage = GeneratorUtils.discoverPackageName(request.getPluginDescriptor());
        if (StringUtils.isEmpty((String)destinationPackage)) {
            return null;
        }
        String packageAsDirectory = StringUtils.replace((String)destinationPackage, (char)'.', (char)'/');
        String outputDirectory = request.getProject().getBuild().getOutputDirectory();
        File helpClassFile = new File(outputDirectory, "HelpMojo.class");
        if (!helpClassFile.exists()) {
            return null;
        }
        File rewriteHelpClassFile = new File(outputDirectory + '/' + packageAsDirectory, "HelpMojo.class");
        if (!rewriteHelpClassFile.getParentFile().exists()) {
            rewriteHelpClassFile.getParentFile().mkdirs();
        }
        FileInputStream fileInputStream = null;
        ClassReader cr = null;
        try {
            fileInputStream = new FileInputStream(helpClassFile);
            cr = new ClassReader((InputStream)fileInputStream);
        }
        catch (IOException e) {
            try {
                throw new GeneratorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileInputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fileInputStream);
        ClassWriter cw = new ClassWriter(0);
        SimpleRemapper packageRemapper = new SimpleRemapper(HELP_MOJO_CLASS_NAME, packageAsDirectory + '/' + HELP_MOJO_CLASS_NAME);
        RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)packageRemapper);
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable e) {
            throw new GeneratorException("ASM issue processing class-file " + helpClassFile.getPath(), e);
        }
        byte[] renamedClass = cw.toByteArray();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(rewriteHelpClassFile);
            fos.write(renamedClass);
        }
        catch (IOException e) {
            try {
                throw new GeneratorException("Error rewriting help class: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)fos);
        helpClassFile.delete();
        return destinationPackage + ".HelpMojo";
    }

    private static void updateHelpMojoDescriptor(PluginDescriptor pluginDescriptor, String helpMojoImplementation) {
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(HELP_GOAL);
        if (mojoDescriptor != null) {
            mojoDescriptor.setImplementation(helpMojoImplementation);
        }
    }
}

