/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.repository.internal.MavenMetadata;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;

final class LocalSnapshotMetadata
extends MavenMetadata {
    private final Artifact artifact;

    public LocalSnapshotMetadata(Artifact artifact) {
        super(LocalSnapshotMetadata.createMetadata(artifact), null);
        this.artifact = artifact;
    }

    public LocalSnapshotMetadata(Artifact artifact, File file) {
        super(LocalSnapshotMetadata.createMetadata(artifact), file);
        this.artifact = artifact;
    }

    private static Metadata createMetadata(Artifact artifact) {
        Snapshot snapshot = new Snapshot();
        snapshot.setLocalCopy(true);
        Versioning versioning = new Versioning();
        versioning.setSnapshot(snapshot);
        Metadata metadata = new Metadata();
        metadata.setVersioning(versioning);
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getBaseVersion());
        return metadata;
    }

    public MavenMetadata setFile(File file) {
        return new LocalSnapshotMetadata(this.artifact, file);
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getVersion();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
    }

    protected void merge(Metadata recessive) {
        this.metadata.getVersioning().updateTimestamp();
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        return this.artifact.getBaseVersion();
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.SNAPSHOT;
    }
}

