/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.MetadataResolver;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.resolution.MetadataRequest;
import org.sonatype.aether.resolution.MetadataResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;
import org.sonatype.aether.util.metadata.DefaultMetadata;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.InvalidVersionSpecificationException;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;
import org.sonatype.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=VersionRangeResolver.class)
public class DefaultVersionRangeResolver
implements VersionRangeResolver,
Service {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private MetadataResolver metadataResolver;

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setMetadataResolver((MetadataResolver)locator.getService(MetadataResolver.class));
    }

    public DefaultVersionRangeResolver setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultVersionRangeResolver setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        VersionConstraint versionConstraint;
        VersionRangeResult result = new VersionRangeResult(request);
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionConstraint = versionScheme.parseVersionConstraint(request.getArtifact().getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            result.addException((Exception)((Object)e));
            throw new VersionRangeResolutionException(result);
        }
        result.setVersionConstraint(versionConstraint);
        if (versionConstraint.getRanges().isEmpty()) {
            result.addVersion(versionConstraint.getVersion());
        } else {
            Map<String, ArtifactRepository> versionIndex = this.getVersions(session, result, request, this.getNature(session, versionConstraint.getRanges()));
            ArrayList<Version> versions = new ArrayList<Version>();
            for (Map.Entry<String, ArtifactRepository> v : versionIndex.entrySet()) {
                try {
                    Version ver = versionScheme.parseVersion(v.getKey());
                    if (!versionConstraint.containsVersion(ver)) continue;
                    versions.add(ver);
                    result.setRepository(ver, v.getValue());
                }
                catch (InvalidVersionSpecificationException e) {
                    result.addException((Exception)((Object)e));
                }
            }
            Collections.sort(versions);
            result.setVersions(versions);
        }
        return result;
    }

    private Map<String, ArtifactRepository> getVersions(RepositorySystemSession session, VersionRangeResult result, VersionRangeRequest request, Metadata.Nature nature) {
        LocalRepositoryManager lrm;
        File localMetadataFile;
        HashMap<String, ArtifactRepository> versionIndex = new HashMap<String, ArtifactRepository>();
        DefaultMetadata metadata = new DefaultMetadata(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), MAVEN_METADATA_XML, nature);
        ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>(request.getRepositories().size());
        for (RemoteRepository repository : request.getRepositories()) {
            MetadataRequest metadataRequest = new MetadataRequest((Metadata)metadata, repository, request.getRequestContext());
            metadataRequest.setDeleteLocalCopyIfMissing(true);
            metadataRequests.add(metadataRequest);
        }
        List metadataResults = this.metadataResolver.resolveMetadata(session, metadataRequests);
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace != null) {
            List versions = workspace.findVersions(request.getArtifact());
            for (String version : versions) {
                versionIndex.put(version, (ArtifactRepository)workspace.getRepository());
            }
        }
        if ((localMetadataFile = new File((lrm = session.getLocalRepositoryManager()).getRepository().getBasedir(), lrm.getPathForLocalMetadata((Metadata)metadata))).isFile()) {
            metadata = metadata.setFile(localMetadataFile);
            Versioning versioning = this.readVersions(session, (Metadata)metadata, result);
            for (String version : versioning.getVersions()) {
                if (versionIndex.containsKey(version)) continue;
                versionIndex.put(version, (ArtifactRepository)lrm.getRepository());
            }
        }
        for (MetadataResult metadataResult : metadataResults) {
            result.addException(metadataResult.getException());
            Versioning versioning = this.readVersions(session, metadataResult.getMetadata(), result);
            for (String version : versioning.getVersions()) {
                if (versionIndex.containsKey(version)) continue;
                versionIndex.put(version, (ArtifactRepository)metadataResult.getRequest().getRepository());
            }
        }
        return versionIndex;
    }

    private Metadata.Nature getNature(RepositorySystemSession session, Collection<VersionRange> ranges) {
        for (VersionRange range : ranges) {
            if (!range.acceptsSnapshots()) continue;
            return Metadata.Nature.RELEASE_OR_SNAPSHOT;
        }
        return Metadata.Nature.RELEASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Versioning readVersions(RepositorySystemSession session, Metadata metadata, VersionRangeResult result) {
        FileInputStream fis;
        Versioning versioning2;
        block6: {
            versioning2 = null;
            fis = null;
            try {
                if (metadata == null || metadata.getFile() == null) break block6;
                fis = new FileInputStream(metadata.getFile());
                org.apache.maven.artifact.repository.metadata.Metadata m = new MetadataXpp3Reader().read((InputStream)fis, false);
                versioning2 = m.getVersioning();
            }
            catch (FileNotFoundException e) {
                IOUtil.close(fis);
            }
            catch (Exception e2) {
                this.invalidMetadata(session, metadata, e2);
                result.addException(e2);
                {
                    catch (Throwable throwable) {
                        IOUtil.close(fis);
                        throw throwable;
                    }
                }
                IOUtil.close((InputStream)fis);
            }
        }
        IOUtil.close(fis);
        return versioning2 != null ? versioning2 : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session, Metadata metadata, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(session, metadata);
            event.setException(exception);
            listener.metadataInvalid((RepositoryEvent)event);
        }
    }
}

