/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.SentinelIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TermAllGroupHeadsCollector<GH extends AbstractAllGroupHeadsCollector.GroupHead>
extends AbstractAllGroupHeadsCollector<GH> {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    final String groupField;
    FieldCache.StringIndex groupIndex;
    IndexReader indexReader;
    int docBase;

    protected TermAllGroupHeadsCollector(String groupField, int numberOfSorts) {
        super(numberOfSorts);
        this.groupField = groupField;
    }

    public static AbstractAllGroupHeadsCollector create(String groupField, Sort sortWithinGroup) throws IOException {
        return TermAllGroupHeadsCollector.create(groupField, sortWithinGroup, 128);
    }

    public static AbstractAllGroupHeadsCollector create(String groupField, Sort sortWithinGroup, int initialSize) throws IOException {
        boolean sortAllScore = true;
        boolean sortAllFieldValue = true;
        for (SortField sortField : sortWithinGroup.getSort()) {
            if (sortField.getType() == 0) {
                sortAllFieldValue = false;
                continue;
            }
            if (TermAllGroupHeadsCollector.needGeneralImpl(sortField)) {
                return new GeneralAllGroupHeadsCollector(groupField, sortWithinGroup);
            }
            sortAllScore = false;
        }
        if (sortAllScore) {
            return new ScoreAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
        }
        if (sortAllFieldValue) {
            return new OrdAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
        }
        return new OrdScoreAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
    }

    private static boolean needGeneralImpl(SortField sortField) {
        int sortType = sortField.getType();
        return sortType != 11 && sortType != 3 && sortType != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        ScoreAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -1);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.order[doc];
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                String term = key == 0 ? null : this.groupIndex.lookup[key];
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key];
            }
            this.temporalResult.groupHead = groupHead;
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.indexReader = reader;
            this.docBase = docBase;
            this.groupIndex = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.lookup.length];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int ord = this.groupIndex.binarySearchLookup((String)collectedGroup.groupValue);
                if (ord < 0) continue;
                this.ordSet.put(ord);
                this.segmentGroupHeads[ord] = collectedGroup;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<String> {
            float[] scores;

            private GroupHead(int doc, String groupValue) throws IOException {
                super(groupValue, doc + ScoreAllGroupHeadsCollector.this.docBase);
                this.scores = new float[ScoreAllGroupHeadsCollector.this.fields.length];
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = score;
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                if (this.scores[compIDX] < score) {
                    return 1;
                }
                if (this.scores[compIDX] > score) {
                    return -1;
                }
                return 0;
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = score;
                }
                this.doc = doc + ScoreAllGroupHeadsCollector.this.docBase;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrdAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private FieldCache.StringIndex[] sortsIndex;
        private GroupHead[] segmentGroupHeads;

        OrdAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -1);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            this.sortsIndex = new FieldCache.StringIndex[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.order[doc];
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                String term = key == 0 ? null : this.groupIndex.lookup[key];
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key];
            }
            this.temporalResult.groupHead = groupHead;
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.indexReader = reader;
            this.docBase = docBase;
            this.groupIndex = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
            for (int i = 0; i < this.fields.length; ++i) {
                this.sortsIndex[i] = FieldCache.DEFAULT.getStringIndex(reader, this.fields[i].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.lookup.length];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int groupOrd = this.groupIndex.binarySearchLookup((String)collectedGroup.groupValue);
                if (groupOrd < 0) continue;
                this.ordSet.put(groupOrd);
                this.segmentGroupHeads[groupOrd] = collectedGroup;
                for (int i = 0; i < this.sortsIndex.length; ++i) {
                    collectedGroup.sortOrds[i] = this.sortsIndex[i].binarySearchLookup(collectedGroup.sortValues[i]);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<String> {
            String[] sortValues;
            int[] sortOrds;

            private GroupHead(int doc, String groupValue) throws IOException {
                super(groupValue, doc + OrdAllGroupHeadsCollector.this.docBase);
                this.sortValues = new String[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i = 0; i < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    this.sortValues[i] = ((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[i].lookup[((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[i].order[doc]];
                    this.sortOrds[i] = ((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[i].order[doc];
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                if (this.sortOrds[compIDX] < 0) {
                    String val1 = this.sortValues[compIDX];
                    String val2 = ((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[compIDX].lookup[((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[compIDX].order[doc]];
                    if (val1 == null) {
                        if (val2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (val2 == null) {
                        return 1;
                    }
                    return val1.compareTo(val2);
                }
                return this.sortOrds[compIDX] - ((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[compIDX].order[doc];
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (int i = 0; i < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    this.sortValues[i] = ((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[i].lookup[((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[i].order[doc]];
                    this.sortOrds[i] = ((OrdAllGroupHeadsCollector)OrdAllGroupHeadsCollector.this).sortsIndex[i].order[doc];
                }
                this.doc = doc + OrdAllGroupHeadsCollector.this.docBase;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrdScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private FieldCache.StringIndex[] sortsIndex;
        private Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        OrdScoreAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -1);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            this.sortsIndex = new FieldCache.StringIndex[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.order[doc];
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                String term = key == 0 ? null : this.groupIndex.lookup[key];
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key];
            }
            this.temporalResult.groupHead = groupHead;
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.indexReader = reader;
            this.docBase = docBase;
            this.groupIndex = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].getType() == 0) continue;
                this.sortsIndex[i] = FieldCache.DEFAULT.getStringIndex(reader, this.fields[i].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.lookup.length];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int ord = this.groupIndex.binarySearchLookup((String)collectedGroup.groupValue);
                if (ord < 0) continue;
                this.ordSet.put(ord);
                this.segmentGroupHeads[ord] = collectedGroup;
                for (int i = 0; i < this.sortsIndex.length; ++i) {
                    if (this.fields[i].getType() == 0) continue;
                    collectedGroup.sortOrds[i] = this.sortsIndex[i].binarySearchLookup(collectedGroup.sortValues[i]);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<String> {
            String[] sortValues;
            int[] sortOrds;
            float[] scores;

            private GroupHead(int doc, String groupValue) throws IOException {
                super(groupValue, doc + OrdScoreAllGroupHeadsCollector.this.docBase);
                this.sortValues = new String[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.scores = new float[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i = 0; i < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i].getType() == 0) {
                        this.scores[i] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortValues[i] = ((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[i].lookup[((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[i].order[doc]];
                    this.sortOrds[i] = ((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[i].order[doc];
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                if (OrdScoreAllGroupHeadsCollector.this.fields[compIDX].getType() == 0) {
                    float score = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                    if (this.scores[compIDX] < score) {
                        return 1;
                    }
                    if (this.scores[compIDX] > score) {
                        return -1;
                    }
                    return 0;
                }
                if (this.sortOrds[compIDX] < 0) {
                    String val1 = this.sortValues[compIDX];
                    String val2 = ((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[compIDX].lookup[((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[compIDX].order[doc]];
                    if (val1 == null) {
                        if (val2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (val2 == null) {
                        return 1;
                    }
                    return val1.compareTo(val2);
                }
                return this.sortOrds[compIDX] - ((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[compIDX].order[doc];
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (int i = 0; i < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i].getType() == 0) {
                        this.scores[i] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortValues[i] = ((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[i].lookup[((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[i].order[doc]];
                    this.sortOrds[i] = ((OrdScoreAllGroupHeadsCollector)OrdScoreAllGroupHeadsCollector.this).sortsIndex[i].order[doc];
                }
                this.doc = doc + OrdScoreAllGroupHeadsCollector.this.docBase;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GeneralAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final Sort sortWithinGroup;
        private final Map<String, GroupHead> groups;
        private Scorer scorer;

        GeneralAllGroupHeadsCollector(String groupField, Sort sortWithinGroup) throws IOException {
            super(groupField, sortWithinGroup.getSort().length);
            this.sortWithinGroup = sortWithinGroup;
            this.groups = new HashMap<String, GroupHead>();
            SortField[] sortFields = sortWithinGroup.getSort();
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
            }
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            int ord = this.groupIndex.order[doc];
            String groupValue = ord == 0 ? null : this.groupIndex.lookup[ord];
            GroupHead groupHead = this.groups.get(groupValue);
            if (groupHead == null) {
                groupHead = new GroupHead(groupValue, this.sortWithinGroup, doc);
                this.groups.put(groupValue == null ? null : groupValue, groupHead);
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.groups.values();
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.indexReader = reader;
            this.docBase = docBase;
            this.groupIndex = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
            for (GroupHead groupHead : this.groups.values()) {
                for (int i = 0; i < groupHead.comparators.length; ++i) {
                    groupHead.comparators[i].setNextReader(reader, docBase);
                }
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            for (GroupHead groupHead : this.groups.values()) {
                for (FieldComparator<?> comparator : groupHead.comparators) {
                    comparator.setScorer(scorer);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<String> {
            final FieldComparator<?>[] comparators;

            private GroupHead(String groupValue, Sort sort, int doc) throws IOException {
                super(groupValue, doc + GeneralAllGroupHeadsCollector.this.docBase);
                SortField[] sortFields = sort.getSort();
                this.comparators = new FieldComparator[sortFields.length];
                for (int i = 0; i < sortFields.length; ++i) {
                    this.comparators[i] = sortFields[i].getComparator(1, i);
                    this.comparators[i].setNextReader(GeneralAllGroupHeadsCollector.this.indexReader, GeneralAllGroupHeadsCollector.this.docBase);
                    this.comparators[i].setScorer(GeneralAllGroupHeadsCollector.this.scorer);
                    this.comparators[i].copy(0, doc);
                    this.comparators[i].setBottom(0);
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                return this.comparators[compIDX].compareBottom(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (FieldComparator<?> comparator : this.comparators) {
                    comparator.copy(0, doc);
                    comparator.setBottom(0);
                }
                this.doc = doc + GeneralAllGroupHeadsCollector.this.docBase;
            }
        }
    }
}

