/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.rangeonrange;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.facet.rangeonrange.Range;

public class DoubleRange
extends Range {
    public final double[] min;
    public final double[] max;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label, 1);
        if (Double.isNaN(minIn)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(maxIn)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = new double[]{minIn};
        this.max = new double[]{maxIn};
    }

    public DoubleRange(String label, double[] min, double[] max) {
        super(label, min.length);
        this.checkArgs(min, max);
        this.min = min;
        this.max = max;
    }

    public String toString() {
        return "DoubleRange(label: " + this.label + ", min: " + Arrays.toString(this.min) + ", max: " + Arrays.toString(this.max) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleRange doubleRange = (DoubleRange)o;
        return Arrays.equals(this.min, doubleRange.min) && Arrays.equals(this.max, doubleRange.max) && this.label.equals(doubleRange.label) && this.dims == doubleRange.dims;
    }

    public int hashCode() {
        return Objects.hash(this.label, Arrays.hashCode(this.min), Arrays.hashCode(this.max), this.dims);
    }

    private void checkArgs(double[] min, double[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            this.failNoMatch();
        }
        if (min.length != max.length) {
            this.failNoMatch();
        }
        for (int i = 0; i < min.length; ++i) {
            if (!(min[i] > max[i])) continue;
            this.failNoMatch();
        }
    }
}

