/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class JapanesePartOfSpeechStopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private boolean enablePositionIncrements;
    private Set<String> stopTags;

    public void inform(ResourceLoader loader) throws IOException {
        String stopTagFiles = (String)this.args.get("tags");
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        this.stopTags = null;
        CharArraySet cas = this.getWordSet(loader, stopTagFiles, false);
        if (cas != null) {
            this.stopTags = new HashSet<String>();
            for (Object element : cas) {
                char[] chars = (char[])element;
                this.stopTags.add(new String(chars));
            }
        }
    }

    public TokenStream create(TokenStream stream) {
        return this.stopTags == null ? stream : new JapanesePartOfSpeechStopFilter(this.enablePositionIncrements, stream, this.stopTags);
    }
}

