/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.StateMgrData;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;

public class TransBinaryDataFile
extends TransactionalComponentLifecycle<TxnBinFile>
implements BinaryDataFile {
    private final FileState stateMgr;
    private final AtomicLong committedLength;
    private final BinaryDataFile binFile;
    private boolean recoveryAction = false;

    public TransBinaryDataFile(BinaryDataFile binFile, ComponentId cid, BufferChannel bufferChannel) {
        super(cid);
        this.stateMgr = new FileState(bufferChannel, 0L, 0L);
        this.binFile = binFile;
        if (!binFile.isOpen()) {
            binFile.open();
        }
        this.committedLength = new AtomicLong(binFile.length());
    }

    public void startRecovery() {
        this.recoveryAction = false;
    }

    public void recover(ByteBuffer ref) {
        this.stateMgr.setState(ref);
        this.committedLength.set(this.stateMgr.length());
        this.recoveryAction = true;
    }

    public void finishRecovery() {
        if (this.recoveryAction) {
            long length = this.committedLength.get();
            this.binFile.truncate(length);
            this.binFile.sync();
            this.committedLength.set(length);
        }
    }

    public void cleanStart() {
    }

    protected TxnBinFile _begin(ReadWrite readWrite, TxnId txnId) {
        return this.createState();
    }

    private TxnBinFile createState() {
        long xLength = this.committedLength.get();
        return new TxnBinFile(xLength);
    }

    protected TxnBinFile _promote(TxnId txnId, TxnBinFile state) {
        return this.createState();
    }

    protected ByteBuffer _commitPrepare(TxnId txnId, TxnBinFile state) {
        this.binFile.sync();
        this.stateMgr.length(this.binFile.length());
        return this.stateMgr.getState();
    }

    protected void _commit(TxnId txnId, TxnBinFile state) {
        if (this.isWriteTxn()) {
            this.stateMgr.writeState();
            this.committedLength.set(this.binFile.length());
        }
    }

    protected void _commitEnd(TxnId txnId, TxnBinFile state) {
    }

    protected void _abort(TxnId txnId, TxnBinFile state) {
        if (this.isWriteTxn()) {
            this.binFile.truncate(this.committedLength.get());
            this.binFile.sync();
        }
    }

    protected void _complete(TxnId txnId, TxnBinFile state) {
    }

    protected void _shutdown() {
    }

    private void checkBoundsReader(long requestedPoint, TxnBinFile state) {
    }

    public void open() {
        if (!this.binFile.isOpen()) {
            this.binFile.open();
        }
    }

    public boolean isOpen() {
        return this.binFile.isOpen();
    }

    public int read(long posn, byte[] b, int start, int length) {
        this.checkTxn();
        if (this.isReadTxn()) {
            this.checkRead(posn);
        }
        return this.binFile.read(posn, b, start, length);
    }

    private void checkRead(long posn) {
        if (posn > ((TxnBinFile)this.getDataState()).length) {
            IO.exception((String)("Out of bounds: (limit " + ((TxnBinFile)this.getDataState()).length + ")" + posn));
        }
    }

    public long write(byte[] b, int start, int length) {
        this.checkWriteTxn();
        return this.binFile.write(b, start, length);
    }

    public void truncate(long size) {
        this.checkWriteTxn();
        TxnBinFile state = (TxnBinFile)this.getDataState();
        if (size < state.length) {
            throw new RuntimeIOException("truncate(" + size + ") to smaller than commited length " + state.length);
        }
        this.binFile.truncate(size);
    }

    public void sync() {
        this.checkWriteTxn();
    }

    public void close() {
        this.stateMgr.close();
        this.binFile.close();
    }

    public long length() {
        super.checkTxn();
        if (this.isReadTxn()) {
            return ((TxnBinFile)this.getDataState()).length;
        }
        return this.binFile.length();
    }

    public boolean isEmpty() {
        super.checkTxn();
        return this.binFile.isEmpty();
    }

    static class FileState
    extends StateMgrData {
        private static int idxLength = 0;

        FileState(BufferChannel bufferChannel, long length, long position) {
            super(bufferChannel, new long[]{length, position});
        }

        long length() {
            return this.get(idxLength);
        }

        void length(long len) {
            this.set(idxLength, len);
        }
    }

    static class TxnBinFile {
        final long length;

        TxnBinFile(long length) {
            this.length = length;
        }
    }
}

