/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.jackrabbit.core.fs.local.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocalCache
extends TestCase {
    private static final String CACHE_DIR = "target/cache";
    private static final String TEMP_DIR = "target/temp";
    private static final String TARGET_DIR = "target";
    private static final Logger LOG = LoggerFactory.getLogger(TestLocalCache.class);

    protected void setUp() {
        try {
            File cachedir = new File(CACHE_DIR);
            if (cachedir.exists()) {
                FileUtil.delete((File)cachedir);
            }
            cachedir.mkdirs();
            File tempdir = new File(TEMP_DIR);
            if (tempdir.exists()) {
                FileUtil.delete((File)tempdir);
            }
            tempdir.mkdirs();
        }
        catch (Exception e) {
            LOG.error("error:", (Throwable)e);
            TestLocalCache.fail();
        }
    }

    protected void tearDown() throws IOException {
        File tempdir;
        File cachedir = new File(CACHE_DIR);
        if (cachedir.exists()) {
            FileUtil.delete((File)cachedir);
        }
        if ((tempdir = new File(TEMP_DIR)).exists()) {
            FileUtil.delete((File)tempdir);
        }
    }

    public void testStoreRetrieve() {
    }

    public void testAutoPurge() {
    }

    public void testAutoPurgeWithPendingUpload() {
    }

    protected void assertEquals(InputStream a, InputStream b) throws IOException {
        int ai;
        do {
            ai = a.read();
            int bi = b.read();
            TestLocalCache.assertEquals((int)ai, (int)bi);
        } while (ai >= 0);
    }
}

