/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.exchange;

import com.ibatis.sqlmap.engine.exchange.ComplexDataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.exchange.DomDataExchange;
import com.ibatis.sqlmap.engine.exchange.JavaBeanDataExchange;
import com.ibatis.sqlmap.engine.exchange.ListDataExchange;
import com.ibatis.sqlmap.engine.exchange.PrimitiveDataExchange;
import com.ibatis.sqlmap.engine.type.DomTypeMarker;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.util.List;
import java.util.Map;

public class DataExchangeFactory {
    private final DataExchange domDataExchange;
    private final DataExchange listDataExchange;
    private final DataExchange mapDataExchange;
    private final DataExchange primitiveDataExchange;
    private final DataExchange complexDataExchange;
    private TypeHandlerFactory typeHandlerFactory;

    public DataExchangeFactory(TypeHandlerFactory typeHandlerFactory) {
        this.typeHandlerFactory = typeHandlerFactory;
        this.domDataExchange = new DomDataExchange(this);
        this.listDataExchange = new ListDataExchange(this);
        this.mapDataExchange = new ComplexDataExchange(this);
        this.primitiveDataExchange = new PrimitiveDataExchange(this);
        this.complexDataExchange = new ComplexDataExchange(this);
    }

    public TypeHandlerFactory getTypeHandlerFactory() {
        return this.typeHandlerFactory;
    }

    public DataExchange getDataExchangeForClass(Class clazz) {
        DataExchange dataExchange = null;
        dataExchange = clazz == null ? this.complexDataExchange : (DomTypeMarker.class.isAssignableFrom(clazz) ? this.domDataExchange : (List.class.isAssignableFrom(clazz) ? this.listDataExchange : (Map.class.isAssignableFrom(clazz) ? this.mapDataExchange : (this.typeHandlerFactory.getTypeHandler(clazz) != null ? this.primitiveDataExchange : new JavaBeanDataExchange(this)))));
        return dataExchange;
    }
}

