/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.external;

import com.ibatis.sqlmap.engine.transaction.BaseTransactionConfig;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.external.ExternalTransaction;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class ExternalTransactionConfig
extends BaseTransactionConfig {
    private DataSource dataSource;
    private boolean defaultAutoCommit = false;
    private boolean setAutoCommitAllowed = true;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public void initialize(Properties props) throws SQLException, TransactionException {
        String dacProp = props.getProperty("DefaultAutoCommit");
        String sacaProp = props.getProperty("SetAutoCommitAllowed");
        this.defaultAutoCommit = "true".equals(dacProp);
        this.setAutoCommitAllowed = "true".equals(sacaProp) || sacaProp == null;
    }

    public Transaction newTransaction(int transactionIsolation) throws SQLException, TransactionException {
        return new ExternalTransaction(this.dataSource, this.defaultAutoCommit, this.setAutoCommitAllowed, transactionIsolation);
    }
}

