/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.common.util.ThrottledPool;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.PaginatedDataList;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import com.ibatis.sqlmap.engine.transaction.user.UserProvidedTransaction;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapExecutorDelegate {
    private static final Probe PROBE = ProbeFactory.getProbe();
    public static final int DEFAULT_MAX_REQUESTS = 512;
    public static final int DEFAULT_MAX_SESSIONS = 128;
    public static final int DEFAULT_MAX_TRANSACTIONS = 32;
    private boolean lazyLoadingEnabled;
    private boolean cacheModelsEnabled;
    private boolean enhancementEnabled;
    private int maxRequests = 512;
    private int maxSessions = 128;
    private int maxTransactions = 32;
    private TransactionManager txManager;
    private HashMap mappedStatements = new HashMap();
    private HashMap cacheModels = new HashMap();
    private HashMap resultMaps = new HashMap();
    private HashMap parameterMaps = new HashMap();
    private ThrottledPool requestPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$RequestScope == null ? (class$com$ibatis$sqlmap$engine$scope$RequestScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.RequestScope")) : class$com$ibatis$sqlmap$engine$scope$RequestScope, 512);
    private ThrottledPool sessionPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$SessionScope == null ? (class$com$ibatis$sqlmap$engine$scope$SessionScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.SessionScope")) : class$com$ibatis$sqlmap$engine$scope$SessionScope, 128);
    protected SqlExecutor sqlExecutor = new SqlExecutor();
    private TypeHandlerFactory typeHandlerFactory = new TypeHandlerFactory();
    private DataExchangeFactory dataExchangeFactory = new DataExchangeFactory(this.typeHandlerFactory);
    private ResultObjectFactory resultObjectFactory;
    private boolean statementCacheEnabled;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$scope$RequestScope;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$scope$SessionScope;

    public DataExchangeFactory getDataExchangeFactory() {
        return this.dataExchangeFactory;
    }

    public TypeHandlerFactory getTypeHandlerFactory() {
        return this.typeHandlerFactory;
    }

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    public boolean isCacheModelsEnabled() {
        return this.cacheModelsEnabled;
    }

    public void setCacheModelsEnabled(boolean cacheModelsEnabled) {
        this.cacheModelsEnabled = cacheModelsEnabled;
    }

    public boolean isEnhancementEnabled() {
        return this.enhancementEnabled;
    }

    public void setEnhancementEnabled(boolean enhancementEnabled) {
        this.enhancementEnabled = enhancementEnabled;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
        this.requestPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$RequestScope == null ? (class$com$ibatis$sqlmap$engine$scope$RequestScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.RequestScope")) : class$com$ibatis$sqlmap$engine$scope$RequestScope, maxRequests);
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
        this.sessionPool = new ThrottledPool(class$com$ibatis$sqlmap$engine$scope$SessionScope == null ? (class$com$ibatis$sqlmap$engine$scope$SessionScope = SqlMapExecutorDelegate.class$("com.ibatis.sqlmap.engine.scope.SessionScope")) : class$com$ibatis$sqlmap$engine$scope$SessionScope, maxSessions);
    }

    public int getMaxTransactions() {
        return this.maxTransactions;
    }

    public void setMaxTransactions(int maxTransactions) {
        this.maxTransactions = maxTransactions;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public void addMappedStatement(MappedStatement ms) {
        if (this.mappedStatements.containsKey(ms.getId())) {
            throw new SqlMapException("There is already a statement named " + ms.getId() + " in this SqlMap.");
        }
        ms.setBaseCacheKey(this.hashCode());
        this.mappedStatements.put(ms.getId(), ms);
    }

    public Iterator getMappedStatementNames() {
        return this.mappedStatements.keySet().iterator();
    }

    public MappedStatement getMappedStatement(String id) {
        MappedStatement ms = (MappedStatement)this.mappedStatements.get(id);
        if (ms == null) {
            throw new SqlMapException("There is no statement named " + id + " in this SqlMap.");
        }
        return ms;
    }

    public void addCacheModel(CacheModel model) {
        this.cacheModels.put(model.getId(), model);
    }

    public Iterator getCacheModelNames() {
        return this.cacheModels.keySet().iterator();
    }

    public CacheModel getCacheModel(String id) {
        CacheModel model = (CacheModel)this.cacheModels.get(id);
        if (model == null) {
            throw new SqlMapException("There is no cache model named " + id + " in this SqlMap.");
        }
        return model;
    }

    public void addResultMap(ResultMap map) {
        this.resultMaps.put(map.getId(), map);
    }

    public Iterator getResultMapNames() {
        return this.resultMaps.keySet().iterator();
    }

    public ResultMap getResultMap(String id) {
        ResultMap map = (ResultMap)this.resultMaps.get(id);
        if (map == null) {
            throw new SqlMapException("There is no result map named " + id + " in this SqlMap.");
        }
        return map;
    }

    public void addParameterMap(ParameterMap map) {
        this.parameterMaps.put(map.getId(), map);
    }

    public Iterator getParameterMapNames() {
        return this.parameterMaps.keySet().iterator();
    }

    public ParameterMap getParameterMap(String id) {
        ParameterMap map = (ParameterMap)this.parameterMaps.get(id);
        if (map == null) {
            throw new SqlMapException("There is no parameter map named " + id + " in this SqlMap.");
        }
        return map;
    }

    public void flushDataCache() {
        Iterator models = this.cacheModels.values().iterator();
        while (models.hasNext()) {
            ((CacheModel)models.next()).flush();
        }
    }

    public void flushDataCache(String id) {
        CacheModel model = this.getCacheModel(id);
        if (model != null) {
            model.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insert(SessionScope session, String id, Object param) throws SQLException {
        Object generatedKey = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(session);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(session, autoStart, trans);
            SelectKeyStatement selectKeyStatement = null;
            if (ms instanceof InsertStatement) {
                selectKeyStatement = ((InsertStatement)ms).getSelectKeyStatement();
            }
            if (selectKeyStatement != null && !selectKeyStatement.isAfter()) {
                generatedKey = this.executeSelectKey(session, trans, ms, param);
            }
            RequestScope request = this.popRequest(session, ms);
            try {
                ms.executeUpdate(request, trans, param);
            }
            finally {
                this.pushRequest(request);
            }
            if (selectKeyStatement != null && selectKeyStatement.isAfter()) {
                generatedKey = this.executeSelectKey(session, trans, ms, param);
            }
            this.autoCommitTransaction(session, autoStart);
        }
        finally {
            this.autoEndTransaction(session, autoStart);
        }
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSelectKey(SessionScope session, Transaction trans, MappedStatement ms, Object param) throws SQLException {
        Object generatedKey = null;
        InsertStatement insert = (InsertStatement)ms;
        SelectKeyStatement selectKeyStatement = insert.getSelectKeyStatement();
        if (selectKeyStatement != null) {
            RequestScope request = this.popRequest(session, selectKeyStatement);
            try {
                generatedKey = selectKeyStatement.executeQueryForObject(request, trans, param, null);
                String keyProp = selectKeyStatement.getKeyProperty();
                if (keyProp != null) {
                    PROBE.setObject(param, keyProp, generatedKey);
                }
            }
            finally {
                this.pushRequest(request);
            }
        }
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(SessionScope session, String id, Object param) throws SQLException {
        int rows = 0;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(session);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(session, autoStart, trans);
            RequestScope request = this.popRequest(session, ms);
            try {
                rows = ms.executeUpdate(request, trans, param);
            }
            finally {
                this.pushRequest(request);
            }
            this.autoCommitTransaction(session, autoStart);
        }
        finally {
            this.autoEndTransaction(session, autoStart);
        }
        return rows;
    }

    public int delete(SessionScope session, String id, Object param) throws SQLException {
        return this.update(session, id, param);
    }

    public Object queryForObject(SessionScope session, String id, Object paramObject) throws SQLException {
        return this.queryForObject(session, id, paramObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object queryForObject(SessionScope session, String id, Object paramObject, Object resultObject) throws SQLException {
        Object object = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(session);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(session, autoStart, trans);
            RequestScope request = this.popRequest(session, ms);
            try {
                object = ms.executeQueryForObject(request, trans, paramObject, resultObject);
            }
            finally {
                this.pushRequest(request);
            }
            this.autoCommitTransaction(session, autoStart);
        }
        finally {
            this.autoEndTransaction(session, autoStart);
        }
        return object;
    }

    public List queryForList(SessionScope session, String id, Object paramObject) throws SQLException {
        return this.queryForList(session, id, paramObject, 0, -999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryForList(SessionScope session, String id, Object paramObject, int skip, int max) throws SQLException {
        List list = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(session);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(session, autoStart, trans);
            RequestScope request = this.popRequest(session, ms);
            try {
                list = ms.executeQueryForList(request, trans, paramObject, skip, max);
            }
            finally {
                this.pushRequest(request);
            }
            this.autoCommitTransaction(session, autoStart);
        }
        finally {
            this.autoEndTransaction(session, autoStart);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryWithRowHandler(SessionScope session, String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(session);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(session, autoStart, trans);
            RequestScope request = this.popRequest(session, ms);
            try {
                ms.executeQueryWithRowHandler(request, trans, paramObject, rowHandler);
            }
            finally {
                this.pushRequest(request);
            }
            this.autoCommitTransaction(session, autoStart);
        }
        finally {
            this.autoEndTransaction(session, autoStart);
        }
    }

    public PaginatedList queryForPaginatedList(SessionScope session, String id, Object paramObject, int pageSize) throws SQLException {
        return new PaginatedDataList(session.getSqlMapExecutor(), id, paramObject, pageSize);
    }

    public Map queryForMap(SessionScope session, String id, Object paramObject, String keyProp) throws SQLException {
        return this.queryForMap(session, id, paramObject, keyProp, null);
    }

    public Map queryForMap(SessionScope session, String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List list = this.queryForList(session, id, paramObject);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            Object key = PROBE.getObject(object, keyProp);
            Object value = null;
            value = valueProp == null ? (Object)object : PROBE.getObject(object, valueProp);
            map.put(key, value);
        }
        return map;
    }

    public void startTransaction(SessionScope session) throws SQLException {
        try {
            this.txManager.begin(session);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + e, e);
        }
    }

    public void startTransaction(SessionScope session, int transactionIsolation) throws SQLException {
        try {
            this.txManager.begin(session, transactionIsolation);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + e, e);
        }
    }

    public void commitTransaction(SessionScope session) throws SQLException {
        try {
            if (session.isInBatch()) {
                this.executeBatch(session);
            }
            this.sqlExecutor.cleanup(session);
            this.txManager.commit(session);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not commit transaction.  Cause: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(SessionScope session) throws SQLException {
        try {
            try {
                this.sqlExecutor.cleanup(session);
            }
            finally {
                this.txManager.end(session);
            }
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error while ending transaction.  Cause: " + e, e);
        }
    }

    public void startBatch(SessionScope session) {
        session.setInBatch(true);
    }

    public int executeBatch(SessionScope session) throws SQLException {
        session.setInBatch(false);
        return this.sqlExecutor.executeBatch(session);
    }

    public List executeBatchDetailed(SessionScope session) throws SQLException, BatchException {
        session.setInBatch(false);
        return this.sqlExecutor.executeBatchDetailed(session);
    }

    public void setUserProvidedTransaction(SessionScope session, Connection userConnection) {
        if (session.getTransactionState() == TransactionState.STATE_USER_PROVIDED) {
            session.recallTransactionState();
        }
        if (userConnection != null) {
            Connection conn = userConnection;
            session.saveTransactionState();
            session.setTransaction(new UserProvidedTransaction(conn));
            session.setTransactionState(TransactionState.STATE_USER_PROVIDED);
        } else {
            session.setTransaction(null);
            session.closePreparedStatements();
            session.reset();
        }
    }

    public DataSource getDataSource() {
        DataSource ds = null;
        if (this.txManager != null) {
            ds = this.txManager.getDataSource();
        }
        return ds;
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public Transaction getTransaction(SessionScope session) {
        return session.getTransaction();
    }

    protected void autoEndTransaction(SessionScope session, boolean autoStart) throws SQLException {
        if (autoStart) {
            session.getSqlMapTxMgr().endTransaction();
        }
    }

    protected void autoCommitTransaction(SessionScope session, boolean autoStart) throws SQLException {
        if (autoStart) {
            session.getSqlMapTxMgr().commitTransaction();
        }
    }

    protected Transaction autoStartTransaction(SessionScope session, boolean autoStart, Transaction trans) throws SQLException {
        Transaction transaction = trans;
        if (autoStart) {
            session.getSqlMapTxMgr().startTransaction();
            transaction = this.getTransaction(session);
        }
        return transaction;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        CacheKey key = new CacheKey();
        if (this.txManager != null) {
            key.update(this.txManager);
            if (this.txManager.getDataSource() != null) {
                key.update(this.txManager.getDataSource());
            }
        }
        key.update(System.identityHashCode(this));
        return key.hashCode();
    }

    protected RequestScope popRequest(SessionScope session, MappedStatement mappedStatement) {
        RequestScope request = (RequestScope)this.requestPool.pop();
        session.incrementRequestStackDepth();
        request.setSession(session);
        mappedStatement.initRequest(request);
        return request;
    }

    protected void pushRequest(RequestScope request) {
        request.getSession().decrementRequestStackDepth();
        request.reset();
        this.requestPool.push(request);
    }

    protected SessionScope popSession() {
        return (SessionScope)this.sessionPool.pop();
    }

    protected void pushSession(SessionScope session) {
        session.reset();
        this.sessionPool.push(session);
    }

    public ResultObjectFactory getResultObjectFactory() {
        return this.resultObjectFactory;
    }

    public void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
        this.resultObjectFactory = resultObjectFactory;
    }

    public boolean isStatementCacheEnabled() {
        return this.statementCacheEnabled;
    }

    public void setStatementCacheEnabled(boolean statementCacheEnabled) {
        this.statementCacheEnabled = statementCacheEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

