/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCookieVirtualHost
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    @Test
    public void testCookieMatchingWithVirtualHosts() throws Exception {
        this.localServer.register("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                int n = Integer.parseInt(request.getFirstHeader("X-Request").getValue());
                switch (n) {
                    case 1: {
                        Assert.assertEquals((Object)"app.mydomain.fr", (Object)request.getFirstHeader("Host").getValue());
                        response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200);
                        response.addHeader((Header)new BasicHeader("Set-Cookie", "name1=value1; domain=mydomain.fr; path=/"));
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((Object)"app.mydomain.fr", (Object)request.getFirstHeader("Host").getValue());
                        Assert.assertNotNull((String)"We must get a cookie header", (Object)request.getFirstHeader("Cookie"));
                        response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200);
                        break;
                    }
                    case 3: {
                        Assert.assertEquals((Object)"app.mydomain.fr", (Object)request.getFirstHeader("Host").getValue());
                        response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200);
                    }
                }
            }
        });
        this.httpclient = HttpClients.createDefault();
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        URI uri = new URI("http://app.mydomain.fr");
        HttpGet httpRequest = new HttpGet(uri);
        httpRequest.addHeader("X-Request", "1");
        CloseableHttpResponse response1 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpRequest, (HttpContext)context);
        HttpEntity e1 = response1.getEntity();
        EntityUtils.consume((HttpEntity)e1);
        List cookies = cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"name1", (Object)((Cookie)cookies.get(0)).getName());
        uri = new URI("http://app.mydomain.fr");
        httpRequest = new HttpGet(uri);
        httpRequest.addHeader("X-Request", "2");
        CloseableHttpResponse response2 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpRequest, (HttpContext)context);
        HttpEntity e2 = response2.getEntity();
        EntityUtils.consume((HttpEntity)e2);
        uri = new URI("http://app.mydomain.fr");
        httpRequest = new HttpGet(uri);
        httpRequest.addHeader("X-Request", "3");
        CloseableHttpResponse response3 = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpRequest, (HttpContext)context);
        HttpEntity e3 = response3.getEntity();
        EntityUtils.consume((HttpEntity)e3);
    }
}

