/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConnectionAutoRelease
extends IntegrationTestBase {
    private PoolingHttpClientConnectionManager mgr;

    @Before
    public void setUp() throws Exception {
        this.startServer();
        this.mgr = new PoolingHttpClientConnectionManager();
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.mgr).build();
    }

    @Test
    public void testReleaseOnEntityConsumeContent() throws Exception {
        this.mgr.setDefaultMaxPerRoute(1);
        this.mgr.setMaxTotal(1);
        PoolStats stats = this.mgr.getTotalStats();
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        HttpGet httpget = new HttpGet("/random/20000");
        HttpHost target = this.getServerHttp();
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget);
        ConnectionRequest connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.get(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        EntityUtils.consume((HttpEntity)e);
        stats = this.mgr.getTotalStats();
        Assert.assertEquals((long)1L, (long)stats.getAvailable());
        connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        HttpClientConnection conn = connreq.get(250L, TimeUnit.MILLISECONDS);
        this.mgr.releaseConnection(conn, null, -1L, null);
    }

    @Test
    public void testReleaseOnEntityWriteTo() throws Exception {
        this.mgr.setDefaultMaxPerRoute(1);
        this.mgr.setMaxTotal(1);
        PoolStats stats = this.mgr.getTotalStats();
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        HttpGet httpget = new HttpGet("/random/20000");
        HttpHost target = this.getServerHttp();
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget);
        ConnectionRequest connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.get(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        ByteArrayOutputStream outsteam = new ByteArrayOutputStream();
        e.writeTo((OutputStream)outsteam);
        stats = this.mgr.getTotalStats();
        Assert.assertEquals((long)1L, (long)stats.getAvailable());
        connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        HttpClientConnection conn = connreq.get(250L, TimeUnit.MILLISECONDS);
        this.mgr.releaseConnection(conn, null, -1L, null);
    }

    @Test
    public void testReleaseOnAbort() throws Exception {
        this.mgr.setDefaultMaxPerRoute(1);
        this.mgr.setMaxTotal(1);
        PoolStats stats = this.mgr.getTotalStats();
        Assert.assertEquals((long)0L, (long)stats.getAvailable());
        HttpGet httpget = new HttpGet("/random/20000");
        HttpHost target = this.getServerHttp();
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget);
        ConnectionRequest connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.get(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        httpget.abort();
        Assert.assertEquals((long)0L, (long)this.mgr.getTotalStats().getAvailable());
        connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        HttpClientConnection conn = connreq.get(250L, TimeUnit.MILLISECONDS);
        this.mgr.releaseConnection(conn, null, -1L, null);
    }

    @Test
    public void testReleaseOnIOException() throws Exception {
        this.localServer.register("/dropdead", new HttpRequestHandler(){

            public void handle(HttpRequest request, final HttpResponse response, final HttpContext context) throws HttpException, IOException {
                BasicHttpEntity entity = new BasicHttpEntity(){

                    public void writeTo(OutputStream outstream) throws IOException {
                        byte[] tmp = new byte[5];
                        outstream.write(tmp);
                        outstream.flush();
                        DefaultBHttpServerConnection conn = (DefaultBHttpServerConnection)context.getAttribute("http.connection");
                        try {
                            conn.sendResponseHeader(response);
                        }
                        catch (HttpException ignore) {
                            // empty catch block
                        }
                    }
                };
                entity.setChunked(true);
                response.setEntity((HttpEntity)entity);
            }
        });
        this.mgr.setDefaultMaxPerRoute(1);
        this.mgr.setMaxTotal(1);
        Assert.assertEquals((long)0L, (long)this.mgr.getTotalStats().getAvailable());
        HttpGet httpget = new HttpGet("/dropdead");
        HttpHost target = this.getServerHttp();
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget);
        ConnectionRequest connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        try {
            connreq.get(250L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException expected) {
            // empty catch block
        }
        HttpEntity e = response.getEntity();
        Assert.assertNotNull((Object)e);
        try {
            EntityUtils.toByteArray((HttpEntity)e);
            Assert.fail((String)"MalformedChunkCodingException should have been thrown");
        }
        catch (MalformedChunkCodingException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.mgr.getTotalStats().getAvailable());
        connreq = this.mgr.requestConnection(new HttpRoute(target), null);
        HttpClientConnection conn = connreq.get(250L, TimeUnit.MILLISECONDS);
        this.mgr.releaseConnection(conn, null, -1L, null);
    }
}

