/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.el;

import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.Coercions;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.Constants;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.Expression;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.ExpressionString;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.Logger;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.parser.ELParser;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.parser.ParseException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.parser.Token;
import org.apache.hadoop.hbase.shaded.org.apache.commons.el.parser.TokenMgrError;

public class ExpressionEvaluatorImpl
extends ExpressionEvaluator {
    static Map sCachedExpressionStrings = Collections.synchronizedMap(new HashMap());
    static Map sCachedExpectedTypes = new HashMap();
    static Logger sLogger = new Logger(System.out);
    boolean mBypassCache;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ExpressionEvaluatorImpl() {
    }

    public ExpressionEvaluatorImpl(boolean pBypassCache) {
        this.mBypassCache = pBypassCache;
    }

    public Object evaluate(String pExpressionString, Class pExpectedType, VariableResolver pResolver, FunctionMapper functions) throws ELException {
        return this.evaluate(pExpressionString, pExpectedType, pResolver, functions, sLogger);
    }

    public javax.servlet.jsp.el.Expression parseExpression(String expression, Class expectedType, FunctionMapper fMapper) throws ELException {
        this.parseExpressionString(expression);
        return new JSTLExpression(this, expression, expectedType, fMapper);
    }

    Object evaluate(String pExpressionString, Class pExpectedType, VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws ELException {
        if (pExpressionString == null) {
            throw new ELException(Constants.NULL_EXPRESSION_STRING);
        }
        Object parsedValue = this.parseExpressionString(pExpressionString);
        if (parsedValue instanceof String) {
            String strValue = (String)parsedValue;
            return this.convertStaticValueToExpectedType(strValue, pExpectedType, pLogger);
        }
        if (parsedValue instanceof Expression) {
            Object value = ((Expression)parsedValue).evaluate(pResolver, functions, pLogger);
            return this.convertToExpectedType(value, pExpectedType, pLogger);
        }
        if (parsedValue instanceof ExpressionString) {
            String strValue = ((ExpressionString)parsedValue).evaluate(pResolver, functions, pLogger);
            return this.convertToExpectedType(strValue, pExpectedType, pLogger);
        }
        return null;
    }

    public Object parseExpressionString(String pExpressionString) throws ELException {
        Object ret;
        if (pExpressionString.length() == 0) {
            return "";
        }
        Object object = ret = this.mBypassCache ? null : (Object)sCachedExpressionStrings.get(pExpressionString);
        if (ret == null) {
            StringReader r = new StringReader(pExpressionString);
            ELParser parser = new ELParser(r);
            try {
                ret = parser.ExpressionString();
                sCachedExpressionStrings.put(pExpressionString, ret);
            }
            catch (ParseException exc) {
                throw new ELException(ExpressionEvaluatorImpl.formatParseException(pExpressionString, exc));
            }
            catch (TokenMgrError exc) {
                throw new ELException(exc.getMessage());
            }
        }
        return ret;
    }

    Object convertToExpectedType(Object pValue, Class pExpectedType, Logger pLogger) throws ELException {
        return Coercions.coerce(pValue, pExpectedType, pLogger);
    }

    Object convertStaticValueToExpectedType(String pValue, Class pExpectedType, Logger pLogger) throws ELException {
        if (pExpectedType == (class$java$lang$String == null ? (class$java$lang$String = ExpressionEvaluatorImpl.class$("java.lang.String")) : class$java$lang$String) || pExpectedType == (class$java$lang$Object == null ? (class$java$lang$Object = ExpressionEvaluatorImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            return pValue;
        }
        Map valueByString = ExpressionEvaluatorImpl.getOrCreateExpectedTypeMap(pExpectedType);
        if (!this.mBypassCache && valueByString.containsKey(pValue)) {
            return valueByString.get(pValue);
        }
        Object ret = Coercions.coerce(pValue, pExpectedType, pLogger);
        valueByString.put(pValue, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class pExpectedType) {
        Map map = sCachedExpectedTypes;
        synchronized (map) {
            Map ret = (Map)sCachedExpectedTypes.get(pExpectedType);
            if (ret == null) {
                ret = Collections.synchronizedMap(new HashMap());
                sCachedExpectedTypes.put(pExpectedType, ret);
            }
            Map map2 = ret;
            return map2;
        }
    }

    static String formatParseException(String pExpressionString, ParseException pExc) {
        StringBuffer expectedBuf = new StringBuffer();
        int maxSize = 0;
        boolean printedOne = false;
        if (pExc.expectedTokenSequences == null) {
            return pExc.toString();
        }
        int i = 0;
        while (i < pExc.expectedTokenSequences.length) {
            if (maxSize < pExc.expectedTokenSequences[i].length) {
                maxSize = pExc.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < pExc.expectedTokenSequences[i].length) {
                if (printedOne) {
                    expectedBuf.append(", ");
                }
                expectedBuf.append(pExc.tokenImage[pExc.expectedTokenSequences[i][j]]);
                printedOne = true;
                ++j;
            }
            ++i;
        }
        String expected = expectedBuf.toString();
        StringBuffer encounteredBuf = new StringBuffer();
        Token tok = pExc.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                encounteredBuf.append(" ");
            }
            if (tok.kind == 0) {
                encounteredBuf.append(pExc.tokenImage[0]);
                break;
            }
            encounteredBuf.append(ExpressionEvaluatorImpl.addEscapes(tok.image));
            tok = tok.next;
            ++i2;
        }
        String encountered = encounteredBuf.toString();
        return MessageFormat.format(Constants.PARSE_EXCEPTION, expected, encountered);
    }

    static String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }

    public String parseAndRender(String pExpressionString) throws ELException {
        Object val = this.parseExpressionString(pExpressionString);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Expression) {
            return "${" + ((Expression)val).getExpressionString() + "}";
        }
        if (val instanceof ExpressionString) {
            return ((ExpressionString)val).getExpressionString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JSTLExpression
    extends javax.servlet.jsp.el.Expression {
        private ExpressionEvaluatorImpl evaluator;
        private String expression;
        private Class expectedType;
        private FunctionMapper fMapper;

        public JSTLExpression(ExpressionEvaluatorImpl evaluator, String expression, Class expectedType, FunctionMapper fMapper) {
            this.evaluator = evaluator;
            this.expression = expression;
            this.expectedType = expectedType;
            this.fMapper = fMapper;
        }

        public Object evaluate(VariableResolver vResolver) throws ELException {
            return this.evaluator.evaluate(this.expression, this.expectedType, vResolver, this.fMapper);
        }
    }
}

