/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.hs.HistoryClientService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.JHSDelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;

public class JobHistoryServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    public static final long historyServerTimeStamp = System.currentTimeMillis();
    private static final Log LOG = LogFactory.getLog(JobHistoryServer.class);
    private HistoryContext historyContext;
    private HistoryClientService clientService;
    private JobHistory jobHistoryService;
    private JHSDelegationTokenSecretManager jhsDTSecretManager;
    private AggregatedLogDeletionService aggLogDelService;

    public JobHistoryServer() {
        super(JobHistoryServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        YarnConfiguration config = new YarnConfiguration(conf);
        config.setBoolean("yarn.dispatcher.exit-on-error", true);
        MRWebAppUtil.initialize((Configuration)this.getConfig());
        HttpConfig.setPolicy((HttpConfig.Policy)MRWebAppUtil.getJHSHttpPolicy());
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("History Server Failed to login", (Throwable)ie);
        }
        this.jobHistoryService = new JobHistory();
        this.historyContext = this.jobHistoryService;
        this.jhsDTSecretManager = this.createJHSSecretManager(conf);
        this.clientService = new HistoryClientService(this.historyContext, this.jhsDTSecretManager);
        this.aggLogDelService = new AggregatedLogDeletionService();
        this.addService((Service)this.jobHistoryService);
        this.addService((Service)this.clientService);
        this.addService((Service)this.aggLogDelService);
        super.serviceInit((Configuration)config);
    }

    protected JHSDelegationTokenSecretManager createJHSSecretManager(Configuration conf) {
        long secretKeyInterval = conf.getLong("mapreduce.cluster.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("mapreduce.cluster.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("mapreduce.cluster.delegation.token.renew-interval", 86400000L);
        return new JHSDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L);
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        SecurityUtil.login((Configuration)conf, (String)"mapreduce.jobhistory.keytab", (String)"mapreduce.jobhistory.principal");
    }

    protected void serviceStart() throws Exception {
        DefaultMetricsSystem.initialize((String)"JobHistoryServer");
        JvmMetrics.initSingleton((String)"JobHistoryServer", null);
        try {
            this.jhsDTSecretManager.startThreads();
        }
        catch (IOException io) {
            LOG.error((Object)"Error while starting the Secret Manager threads", (Throwable)io);
            throw io;
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.jhsDTSecretManager != null) {
            this.jhsDTSecretManager.stopThreads();
        }
        DefaultMetricsSystem.shutdown();
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public HistoryClientService getClientService() {
        return this.clientService;
    }

    static JobHistoryServer launchJobHistoryServer(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(JobHistoryServer.class, (String[])args, (Log)LOG);
        JobHistoryServer jobHistoryServer = null;
        try {
            jobHistoryServer = new JobHistoryServer();
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)jobHistoryServer), 30);
            YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
            jobHistoryServer.init((Configuration)conf);
            jobHistoryServer.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting JobHistoryServer", t);
            ExitUtil.terminate((int)-1, (String)"Error starting JobHistoryServer");
        }
        return jobHistoryServer;
    }

    public static void main(String[] args) {
        JobHistoryServer.launchJobHistoryServer(args);
    }
}

