/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

public class TestNetworkTopologyWithNodeGroup
extends TestCase {
    private static final NetworkTopologyWithNodeGroup cluster = new NetworkTopologyWithNodeGroup();
    private static final DatanodeDescriptor[] dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1/s1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1/s1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r1/s2"), DFSTestUtil.getDatanodeDescriptor("4.4.4.4", "/d1/r2/s3"), DFSTestUtil.getDatanodeDescriptor("5.5.5.5", "/d1/r2/s3"), DFSTestUtil.getDatanodeDescriptor("6.6.6.6", "/d1/r2/s4"), DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r3/s5"), DFSTestUtil.getDatanodeDescriptor("8.8.8.8", "/d2/r3/s6")};
    private static final NodeBase computeNode = new NodeBase("/d1/r1/s1/h9");

    public void testNumOfChildren() throws Exception {
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getNumOfLeaves(), (int)dataNodes.length);
    }

    public void testNumOfRacks() throws Exception {
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getNumOfRacks(), (int)3);
    }

    public void testRacks() throws Exception {
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getNumOfRacks(), (int)3);
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)dataNodes[1]));
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[1], (Node)dataNodes[2]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)dataNodes[3]));
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[3], (Node)dataNodes[4]));
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[4], (Node)dataNodes[5]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[5], (Node)dataNodes[6]));
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[6], (Node)dataNodes[7]));
    }

    public void testNodeGroups() throws Exception {
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getNumOfRacks(), (int)3);
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[0], (Node)dataNodes[1]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[1], (Node)dataNodes[2]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[2], (Node)dataNodes[3]));
        TestNetworkTopologyWithNodeGroup.assertTrue((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[3], (Node)dataNodes[4]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[4], (Node)dataNodes[5]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[5], (Node)dataNodes[6]));
        TestNetworkTopologyWithNodeGroup.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[6], (Node)dataNodes[7]));
    }

    public void testGetDistance() throws Exception {
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[0]), (int)0);
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[1]), (int)2);
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[2]), (int)4);
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[3]), (int)6);
        TestNetworkTopologyWithNodeGroup.assertEquals((int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[6]), (int)8);
    }

    public void testPseudoSortByDistance() throws Exception {
        DatanodeDescriptor[] testNodes = new DatanodeDescriptor[]{dataNodes[1], dataNodes[2], dataNodes[3], dataNodes[0]};
        cluster.pseudoSortByDistance((Node)dataNodes[0], (Node[])testNodes);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[2] == dataNodes[2] ? 1 : 0) != 0);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[3] == dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[3];
        testNodes[1] = dataNodes[4];
        testNodes[2] = dataNodes[1];
        testNodes[3] = dataNodes[0];
        cluster.pseudoSortByDistance((Node)dataNodes[0], (Node[])testNodes);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[5];
        testNodes[1] = dataNodes[3];
        testNodes[2] = dataNodes[2];
        testNodes[3] = dataNodes[0];
        cluster.pseudoSortByDistance((Node)dataNodes[0], (Node[])testNodes);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[1] == dataNodes[2] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[6];
        testNodes[1] = dataNodes[7];
        testNodes[2] = dataNodes[2];
        testNodes[3] = dataNodes[0];
        cluster.pseudoSortByDistance((Node)computeNode, (Node[])testNodes);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        TestNetworkTopologyWithNodeGroup.assertTrue((testNodes[1] == dataNodes[2] ? 1 : 0) != 0);
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (DatanodeDescriptor dnd : dataNodes) {
            frequency.put((Node)dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope);
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        return frequency;
    }

    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath((Node)dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope);
        for (DatanodeDescriptor key : dataNodes) {
            TestNetworkTopologyWithNodeGroup.assertTrue((frequency.get(key) > 0 || key == dataNodes[0] ? 1 : 0) != 0);
        }
    }

    static {
        for (int i = 0; i < dataNodes.length; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
    }
}

