/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.Diff;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSetQuotaWithSnapshot {
    protected static final long seed = 0L;
    protected static final short REPLICATION = 3;
    protected static final long BLOCKSIZE = 1024L;
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected FSNamesystem fsn;
    protected FSDirectory fsdir;
    protected DistributedFileSystem hdfs;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.hdfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testSetQuota() throws Exception {
        Path dir = new Path("/TestSnapshot");
        this.hdfs.mkdirs(dir);
        SnapshotTestHelper.createSnapshot(this.hdfs, dir, "s1");
        Path sub = new Path(dir, "sub");
        this.hdfs.mkdirs(sub);
        Path fileInSub = new Path(sub, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInSub, 1024L, (short)3, 0L);
        INodeDirectory subNode = INodeDirectory.valueOf((INode)this.fsdir.getINode(sub.toString()), (Object)sub);
        Assert.assertFalse((boolean)(subNode instanceof INodeDirectoryWithSnapshot));
        this.hdfs.setQuota(sub, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        subNode = INodeDirectory.valueOf((INode)this.fsdir.getINode(sub.toString()), (Object)sub);
        Assert.assertTrue((boolean)subNode.isQuotaSet());
        Assert.assertFalse((boolean)(subNode instanceof INodeDirectoryWithSnapshot));
    }

    @Test
    public void testClearQuota() throws Exception {
        Path dir = new Path("/TestSnapshot");
        this.hdfs.mkdirs(dir);
        this.hdfs.allowSnapshot(dir);
        this.hdfs.setQuota(dir, Long.MAX_VALUE, Long.MAX_VALUE);
        INode dirNode = this.fsdir.getINode4Write(dir.toString());
        Assert.assertTrue((boolean)(dirNode instanceof INodeDirectorySnapshottable));
        Assert.assertEquals((long)0L, (long)((INodeDirectorySnapshottable)dirNode).getDiffs().asList().size());
        this.hdfs.setQuota(dir, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        dirNode = this.fsdir.getINode4Write(dir.toString());
        Assert.assertTrue((boolean)(dirNode instanceof INodeDirectorySnapshottable));
        Assert.assertEquals((long)0L, (long)((INodeDirectorySnapshottable)dirNode).getDiffs().asList().size());
        this.hdfs.setQuota(dir, -1L, -1L);
        dirNode = this.fsdir.getINode4Write(dir.toString());
        Assert.assertTrue((boolean)(dirNode instanceof INodeDirectorySnapshottable));
        Assert.assertEquals((long)0L, (long)((INodeDirectorySnapshottable)dirNode).getDiffs().asList().size());
        SnapshotTestHelper.createSnapshot(this.hdfs, dir, "s1");
        this.hdfs.setQuota(dir, -1L, -1L);
        dirNode = this.fsdir.getINode4Write(dir.toString());
        Assert.assertTrue((boolean)(dirNode instanceof INodeDirectorySnapshottable));
        Assert.assertEquals((long)1L, (long)((INodeDirectorySnapshottable)dirNode).getDiffs().asList().size());
        SnapshottableDirectoryStatus[] status = this.hdfs.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertEquals((Object)dir, (Object)status[0].getFullPath());
        Path subDir = new Path(dir, "sub");
        this.hdfs.mkdirs(subDir);
        this.hdfs.createSnapshot(dir, "s2");
        Path file = new Path(subDir, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
        this.hdfs.setQuota(dir, -1L, -1L);
        INode subNode = this.fsdir.getINode4Write(subDir.toString());
        Assert.assertTrue((boolean)(subNode instanceof INodeDirectoryWithSnapshot));
        List diffList = ((INodeDirectoryWithSnapshot)subNode).getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        Assert.assertEquals((Object)"s2", (Object)Snapshot.getSnapshotName((Snapshot)((INodeDirectoryWithSnapshot.DirectoryDiff)diffList.get((int)0)).snapshot));
        List createdList = ((INodeDirectoryWithSnapshot.DirectoryDiff)diffList.get(0)).getChildrenDiff().getList(Diff.ListType.CREATED);
        Assert.assertEquals((long)1L, (long)createdList.size());
        Assert.assertSame((Object)this.fsdir.getINode4Write(file.toString()), createdList.get(0));
    }
}

