/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBootstrapStandbyWithQJM {
    private static final String NAMESERVICE = "ns1";
    private static final String NN1 = "nn1";
    private static final String NN2 = "nn2";
    private static final int NUM_JN = 3;
    private static final int NN1_IPC_PORT = 10000;
    private static final int NN1_INFO_PORT = 10001;
    private static final int NN2_IPC_PORT = 10002;
    private static final int NN2_INFO_PORT = 10003;
    private MiniDFSCluster cluster;
    private MiniJournalCluster jCluster;

    @Before
    public void setup() throws Exception {
        this.jCluster = new MiniJournalCluster.Builder(new Configuration()).format(true).numJournalNodes(3).build();
        URI journalURI = this.jCluster.getQuorumJournalURI(NAMESERVICE);
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf(NAMESERVICE).addNN(new MiniDFSNNTopology.NNConf(NN1).setIpcPort(10000).setHttpPort(10001)).addNN(new MiniDFSNNTopology.NNConf(NN2).setIpcPort(10002).setHttpPort(10003)));
        Configuration conf = this.initHAConf(journalURI);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(1).manageNameDfsSharedDirs(false).build();
        this.cluster.waitActive();
        Configuration confNN0 = new Configuration(conf);
        this.cluster.shutdown();
        confNN0.set("dfs.ha.namenode.id", NN1);
        NameNode.initializeSharedEdits((Configuration)confNN0, (boolean)true);
        this.cluster = new MiniDFSCluster.Builder(conf).format(false).nnTopology(topology).numDataNodes(1).manageNameDfsSharedDirs(false).build();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        DistributedFileSystem dfs = (DistributedFileSystem)HATestUtil.configureFailoverFs(this.cluster, conf);
        dfs.mkdirs(new Path("/test2"));
        dfs.close();
    }

    @After
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.jCluster != null) {
            this.jCluster.shutdown();
        }
    }

    private Configuration initHAConf(URI journalURI) {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.shared.edits.dir", journalURI.toString());
        String address1 = "127.0.0.1:10000";
        String address2 = "127.0.0.1:10002";
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NAMESERVICE, NN1}), address1);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NAMESERVICE, NN2}), address2);
        conf.set("dfs.nameservices", NAMESERVICE);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NAMESERVICE}), "nn1,nn2");
        conf.set("dfs.client.failover.proxy.provider.ns1", ConfiguredFailoverProxyProvider.class.getName());
        conf.set("fs.defaultFS", "hdfs://ns1");
        return conf;
    }

    @Test
    public void testBootstrapStandbyWithStandbyNN() throws Exception {
        this.cluster.transitionToStandby(0);
        Configuration confNN1 = this.cluster.getConfiguration(1);
        this.cluster.shutdownNameNode(1);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)confNN1);
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
    }

    @Test
    public void testBootstrapStandbyWithActiveNN() throws Exception {
        this.cluster.transitionToActive(0);
        Configuration confNN1 = this.cluster.getConfiguration(1);
        this.cluster.shutdownNameNode(1);
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)confNN1);
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
    }
}

