/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.junit.Assert;
import org.junit.Test;

public class TestHeartbeatHandling {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeat() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            HeartbeatManager hm = namesystem.getBlockManager().getDatanodeManager().getHeartbeatManager();
            String poolId = namesystem.getBlockPoolId();
            DatanodeRegistration nodeReg = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(0), poolId);
            DatanodeDescriptor dd = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg);
            boolean REMAINING_BLOCKS = true;
            int MAX_REPLICATE_LIMIT = conf.getInt("dfs.namenode.replication.max-streams", 2);
            int MAX_INVALIDATE_LIMIT = 1000;
            int MAX_INVALIDATE_BLOCKS = 2001;
            int MAX_REPLICATE_BLOCKS = 2 * MAX_REPLICATE_LIMIT + 1;
            DatanodeDescriptor[] ONE_TARGET = new DatanodeDescriptor[1];
            try {
                namesystem.writeLock();
                HeartbeatManager heartbeatManager = hm;
                synchronized (heartbeatManager) {
                    for (int i = 0; i < MAX_REPLICATE_BLOCKS; ++i) {
                        dd.addBlockToBeReplicated(new Block((long)i, 0L, 1000L), ONE_TARGET);
                    }
                    DatanodeCommand[] cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem).getCommands();
                    Assert.assertEquals((long)1L, (long)cmds.length);
                    Assert.assertEquals((long)1L, (long)cmds[0].getAction());
                    Assert.assertEquals((long)MAX_REPLICATE_LIMIT, (long)((BlockCommand)cmds[0]).getBlocks().length);
                    ArrayList<Block> blockList = new ArrayList<Block>(2001);
                    for (int i = 0; i < 2001; ++i) {
                        blockList.add(new Block((long)i, 0L, 1000L));
                    }
                    dd.addBlocksToBeInvalidated(blockList);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem).getCommands();
                    Assert.assertEquals((long)2L, (long)cmds.length);
                    Assert.assertEquals((long)1L, (long)cmds[0].getAction());
                    Assert.assertEquals((long)MAX_REPLICATE_LIMIT, (long)((BlockCommand)cmds[0]).getBlocks().length);
                    Assert.assertEquals((long)2L, (long)cmds[1].getAction());
                    Assert.assertEquals((long)1000L, (long)((BlockCommand)cmds[1]).getBlocks().length);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem).getCommands();
                    Assert.assertEquals((long)2L, (long)cmds.length);
                    Assert.assertEquals((long)1L, (long)cmds[0].getAction());
                    Assert.assertEquals((long)1L, (long)((BlockCommand)cmds[0]).getBlocks().length);
                    Assert.assertEquals((long)2L, (long)cmds[1].getAction());
                    Assert.assertEquals((long)1000L, (long)((BlockCommand)cmds[1]).getBlocks().length);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem).getCommands();
                    Assert.assertEquals((long)1L, (long)cmds.length);
                    Assert.assertEquals((long)2L, (long)cmds[0].getAction());
                    Assert.assertEquals((long)1L, (long)((BlockCommand)cmds[0]).getBlocks().length);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem).getCommands();
                    Assert.assertEquals((long)0L, (long)cmds.length);
                }
            }
            finally {
                namesystem.writeUnlock();
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatBlockRecovery() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            HeartbeatManager hm = namesystem.getBlockManager().getDatanodeManager().getHeartbeatManager();
            String poolId = namesystem.getBlockPoolId();
            DatanodeRegistration nodeReg1 = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(0), poolId);
            DatanodeDescriptor dd1 = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg1);
            DatanodeRegistration nodeReg2 = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(1), poolId);
            DatanodeDescriptor dd2 = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg2);
            DatanodeRegistration nodeReg3 = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(2), poolId);
            DatanodeDescriptor dd3 = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg3);
            try {
                namesystem.writeLock();
                HeartbeatManager heartbeatManager = hm;
                synchronized (heartbeatManager) {
                    NameNodeAdapter.sendHeartBeat(nodeReg1, dd1, namesystem);
                    NameNodeAdapter.sendHeartBeat(nodeReg2, dd2, namesystem);
                    NameNodeAdapter.sendHeartBeat(nodeReg3, dd3, namesystem);
                    dd1.setLastUpdate(System.currentTimeMillis());
                    dd2.setLastUpdate(System.currentTimeMillis());
                    dd3.setLastUpdate(System.currentTimeMillis());
                    BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(new Block(0L, 0L, 1000L), 3, HdfsServerConstants.BlockUCState.UNDER_RECOVERY, new DatanodeDescriptor[]{dd1, dd2, dd3});
                    dd1.addBlockToBeRecovered(blockInfo);
                    DatanodeCommand[] cmds = NameNodeAdapter.sendHeartBeat(nodeReg1, dd1, namesystem).getCommands();
                    Assert.assertEquals((long)1L, (long)cmds.length);
                    Assert.assertEquals((long)6L, (long)cmds[0].getAction());
                    BlockRecoveryCommand recoveryCommand = (BlockRecoveryCommand)cmds[0];
                    Assert.assertEquals((long)1L, (long)recoveryCommand.getRecoveringBlocks().size());
                    DatanodeInfo[] recoveringNodes = recoveryCommand.getRecoveringBlocks().toArray(new BlockRecoveryCommand.RecoveringBlock[0])[0].getLocations();
                    Assert.assertEquals((long)3L, (long)recoveringNodes.length);
                    Assert.assertEquals((Object)recoveringNodes[0], (Object)dd1);
                    Assert.assertEquals((Object)recoveringNodes[1], (Object)dd2);
                    Assert.assertEquals((Object)recoveringNodes[2], (Object)dd3);
                    dd1.setLastUpdate(System.currentTimeMillis());
                    dd2.setLastUpdate(System.currentTimeMillis() - 40000L);
                    dd3.setLastUpdate(System.currentTimeMillis());
                    blockInfo = new BlockInfoUnderConstruction(new Block(0L, 0L, 1000L), 3, HdfsServerConstants.BlockUCState.UNDER_RECOVERY, new DatanodeDescriptor[]{dd1, dd2, dd3});
                    dd1.addBlockToBeRecovered(blockInfo);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg1, dd1, namesystem).getCommands();
                    Assert.assertEquals((long)1L, (long)cmds.length);
                    Assert.assertEquals((long)6L, (long)cmds[0].getAction());
                    recoveryCommand = (BlockRecoveryCommand)cmds[0];
                    Assert.assertEquals((long)1L, (long)recoveryCommand.getRecoveringBlocks().size());
                    recoveringNodes = recoveryCommand.getRecoveringBlocks().toArray(new BlockRecoveryCommand.RecoveringBlock[0])[0].getLocations();
                    Assert.assertEquals((long)2L, (long)recoveringNodes.length);
                    Assert.assertEquals((Object)recoveringNodes[0], (Object)dd1);
                    Assert.assertEquals((Object)recoveringNodes[1], (Object)dd3);
                    dd1.setLastUpdate(System.currentTimeMillis() - 60000L);
                    dd2.setLastUpdate(System.currentTimeMillis() - 40000L);
                    dd3.setLastUpdate(System.currentTimeMillis() - 80000L);
                    blockInfo = new BlockInfoUnderConstruction(new Block(0L, 0L, 1000L), 3, HdfsServerConstants.BlockUCState.UNDER_RECOVERY, new DatanodeDescriptor[]{dd1, dd2, dd3});
                    dd1.addBlockToBeRecovered(blockInfo);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg1, dd1, namesystem).getCommands();
                    Assert.assertEquals((long)1L, (long)cmds.length);
                    Assert.assertEquals((long)6L, (long)cmds[0].getAction());
                    recoveryCommand = (BlockRecoveryCommand)cmds[0];
                    Assert.assertEquals((long)1L, (long)recoveryCommand.getRecoveringBlocks().size());
                    recoveringNodes = recoveryCommand.getRecoveringBlocks().toArray(new BlockRecoveryCommand.RecoveringBlock[0])[0].getLocations();
                    Assert.assertEquals((long)3L, (long)recoveringNodes.length);
                    Assert.assertEquals((Object)recoveringNodes[0], (Object)dd1);
                    Assert.assertEquals((Object)recoveringNodes[1], (Object)dd2);
                    Assert.assertEquals((Object)recoveringNodes[2], (Object)dd3);
                }
            }
            finally {
                namesystem.writeUnlock();
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

