/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestComputeInvalidateWork {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompInvalidate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int NUM_OF_DATANODES = 3;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            BlockManager bm = namesystem.getBlockManager();
            int blockInvalidateLimit = bm.getDatanodeManager().blockInvalidateLimit;
            DatanodeDescriptor[] nodes = bm.getDatanodeManager().getHeartbeatManager().getDatanodes();
            Assert.assertEquals((long)nodes.length, (long)3L);
            namesystem.writeLock();
            try {
                for (int i = 0; i < nodes.length; ++i) {
                    for (int j = 0; j < 3 * blockInvalidateLimit + 1; ++j) {
                        Block block = new Block((long)(i * (blockInvalidateLimit + 1) + j), 0L, 1000L);
                        bm.addToInvalidates(block, (DatanodeInfo)nodes[i]);
                    }
                }
                Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)bm.computeInvalidateWork(4));
                Assert.assertEquals((long)(blockInvalidateLimit * 3), (long)bm.computeInvalidateWork(3));
                Assert.assertEquals((long)(blockInvalidateLimit * 2), (long)bm.computeInvalidateWork(2));
                int workCount = bm.computeInvalidateWork(1);
                if (workCount == 1) {
                    Assert.assertEquals((long)(blockInvalidateLimit + 1), (long)bm.computeInvalidateWork(2));
                } else {
                    Assert.assertEquals((long)workCount, (long)blockInvalidateLimit);
                    Assert.assertEquals((long)2L, (long)bm.computeInvalidateWork(2));
                }
            }
            finally {
                namesystem.writeUnlock();
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

