/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.ThreadUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSClientExcludedNodes {
    @Test(timeout=10000L)
    public void testExcludedNodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path filePath = new Path("/testExcludedNodes");
        cluster.stopDataNode(AppendTestUtil.nextInt(3));
        FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, fs.getDefaultBlockSize(filePath));
        out.write(20);
        try {
            out.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Single DN failure should not result in a block abort: \n" + e.getMessage()));
        }
    }

    @Test(timeout=10000L)
    public void testExcludedNodesForgiveness() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.client.write.exclude.nodes.cache.expiry.interval.millis", 1000L);
        conf.setInt("io.bytes.per.checksum", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        ArrayList<MiniDFSCluster.DataNodeProperties> props = cluster.dataNodes;
        DistributedFileSystem fs = cluster.getFileSystem();
        Path filePath = new Path("/testForgivingExcludedNodes");
        byte[] bytes = new byte[256];
        for (int index = 0; index < bytes.length; ++index) {
            bytes[index] = 48;
        }
        FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
        out.write(bytes);
        out.write(bytes);
        out.hflush();
        MiniDFSCluster.DataNodeProperties two = cluster.stopDataNode(2);
        MiniDFSCluster.DataNodeProperties one = cluster.stopDataNode(1);
        out.write(bytes);
        out.write(bytes);
        out.hflush();
        junit.framework.Assert.assertEquals((boolean)true, (boolean)cluster.restartDataNode(one, true));
        junit.framework.Assert.assertEquals((boolean)true, (boolean)cluster.restartDataNode(two, true));
        cluster.waitActive();
        ThreadUtil.sleepAtLeastIgnoreInterrupts((long)2000L);
        cluster.stopDataNode(0);
        try {
            out.write(bytes);
            out.hflush();
            out.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Excluded DataNodes should be forgiven after a while and not cause file writing exception of: '" + e.getMessage() + "'"));
        }
    }
}

