/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestBlockReaderLocal {
    public static void assertArrayRegionsEqual(byte[] buf1, int off1, byte[] buf2, int off2, int len) {
        for (int i = 0; i < len; ++i) {
            if (buf1[off1 + i] == buf2[off2 + i]) continue;
            Assert.fail((String)("arrays differ at byte " + i + ". " + "The first array has " + buf1[off1 + i] + ", but the second array has " + buf2[off2 + i]));
        }
    }

    private static void readFully(BlockReaderLocal reader, ByteBuffer buf, int off, int len) throws IOException {
        int amt = len;
        while (amt > 0) {
            buf.limit(off + len);
            buf.position(off);
            long ret = reader.read(buf);
            if (ret < 0L) {
                throw new EOFException("Premature EOF from BlockReaderLocal after reading " + (len - amt) + " byte(s).");
            }
            amt = (int)((long)amt - ret);
            off = (int)((long)off + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBlockReaderLocalTest(BlockReaderLocalTest test, boolean checksum) throws IOException {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", !checksum);
        conf.set("dfs.checksum.type", "CRC32C");
        FileInputStream dataIn = null;
        FileInputStream checkIn = null;
        Path TEST_PATH = new Path("/a");
        long RANDOM_SEED = 4567L;
        BlockReaderLocal blockReaderLocal = null;
        FSDataInputStream fsIn = null;
        byte[] original = new byte[12345];
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 4567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            fsIn.close();
            fsIn = null;
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, TEST_PATH);
            File dataFile = MiniDFSCluster.getBlockFile(0, block);
            File metaFile = MiniDFSCluster.getBlockMetadataFile(0, block);
            DatanodeID datanodeID = cluster.getDataNodes().get(0).getDatanodeId();
            cluster.shutdown();
            cluster = null;
            test.setup(dataFile, checksum);
            dataIn = new FileInputStream(dataFile);
            checkIn = new FileInputStream(metaFile);
            blockReaderLocal = new BlockReaderLocal(new DFSClient.Conf((Configuration)conf), TEST_PATH.getName(), block, 0L, -1L, dataIn, checkIn, datanodeID, checksum, null);
            dataIn = null;
            checkIn = null;
            test.doTest(blockReaderLocal, original);
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            if (dataIn != null) {
                dataIn.close();
            }
            if (checkIn != null) {
                checkIn.close();
            }
            if (blockReaderLocal != null) {
                blockReaderLocal.close();
            }
        }
    }

    @Test
    public void testBlockReaderLocalImmediateClose() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalImmediateClose(), true);
        this.runBlockReaderLocalTest(new TestBlockReaderLocalImmediateClose(), false);
    }

    @Test
    public void testBlockReaderSimpleReads() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), true);
    }

    @Test
    public void testBlockReaderSimpleReadsNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), false);
    }

    @Test
    public void testBlockReaderLocalArrayReads2() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalArrayReads2(), true);
    }

    @Test
    public void testBlockReaderLocalArrayReads2NoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalArrayReads2(), false);
    }

    @Test
    public void testBlockReaderLocalByteBufferReads() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferReads(), true);
    }

    @Test
    public void testBlockReaderLocalByteBufferReadsNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferReads(), false);
    }

    @Test
    public void testBlockReaderLocalReadCorruptStart() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorruptStart(), true);
    }

    @Test
    public void testBlockReaderLocalReadCorrupt() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorrupt(), true);
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorrupt(), false);
    }

    @Test(timeout=60000L)
    public void TestStatisticsForShortCircuitLocalRead() throws Exception {
        this.testStatistics(true);
    }

    @Test(timeout=60000L)
    public void TestStatisticsForLocalRead() throws Exception {
        this.testStatistics(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStatistics(boolean isShortCircuit) throws Exception {
        Assume.assumeTrue((DomainSocket.getLoadingFailureReason() == null ? 1 : 0) != 0);
        HdfsConfiguration conf = new HdfsConfiguration();
        TemporarySocketDirectory sockDir = null;
        if (isShortCircuit) {
            DFSInputStream.tcpReadsDisabledForTesting = true;
            sockDir = new TemporarySocketDirectory();
            conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestStatisticsForLocalRead.%d.sock").getAbsolutePath());
            conf.setBoolean("dfs.client.read.shortcircuit", true);
            DomainSocket.disableBindPathValidation();
        } else {
            conf.setBoolean("dfs.client.read.shortcircuit", false);
        }
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        long RANDOM_SEED = 4567L;
        FSDataInputStream fsIn = null;
        byte[] original = new byte[12345];
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 4567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            Assert.assertEquals((long)12345L, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)12345L, (long)dfsIn.getReadStatistics().getTotalLocalBytesRead());
            if (isShortCircuit) {
                Assert.assertEquals((long)12345L, (long)dfsIn.getReadStatistics().getTotalShortCircuitBytesRead());
            } else {
                Assert.assertEquals((long)0L, (long)dfsIn.getReadStatistics().getTotalShortCircuitBytesRead());
            }
            fsIn.close();
            fsIn = null;
        }
        finally {
            DFSInputStream.tcpReadsDisabledForTesting = false;
            if (fsIn != null) {
                fsIn.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            if (sockDir != null) {
                sockDir.close();
            }
        }
    }

    private static class TestBlockReaderLocalReadCorrupt
    implements BlockReaderLocalTest {
        boolean usingChecksums = false;

        private TestBlockReaderLocalReadCorrupt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
            RandomAccessFile bf = null;
            this.usingChecksums = usingChecksums;
            try {
                bf = new RandomAccessFile(blockFile, "rw");
                bf.seek(1539L);
                bf.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            }
            finally {
                if (bf != null) {
                    bf.close();
                }
            }
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            block3: {
                byte[] buf = new byte[12345];
                try {
                    reader.readFully(buf, 0, 10);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf, 0, 10);
                    reader.readFully(buf, 10, 100);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf, 10, 100);
                    reader.readFully(buf, 110, 700);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf, 110, 700);
                    reader.skip(1L);
                    reader.readFully(buf, 811, 5);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf, 811, 5);
                    reader.readFully(buf, 816, 900);
                    if (this.usingChecksums) {
                        Assert.fail((String)"did not detect corruption");
                    }
                }
                catch (ChecksumException e) {
                    if (this.usingChecksums) break block3;
                    Assert.fail((String)"didn't expect to get ChecksumException: not using checksums.");
                }
            }
        }
    }

    private static class TestBlockReaderLocalReadCorruptStart
    implements BlockReaderLocalTest {
        boolean usingChecksums = false;

        private TestBlockReaderLocalReadCorruptStart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
            RandomAccessFile bf = null;
            this.usingChecksums = usingChecksums;
            try {
                bf = new RandomAccessFile(blockFile, "rw");
                bf.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            }
            finally {
                if (bf != null) {
                    bf.close();
                }
            }
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] buf = new byte[12345];
            if (this.usingChecksums) {
                try {
                    reader.readFully(buf, 0, 10);
                    Assert.fail((String)"did not detect corruption");
                }
                catch (IOException e) {}
            } else {
                reader.readFully(buf, 0, 10);
            }
        }
    }

    private static class TestBlockReaderLocalByteBufferReads
    implements BlockReaderLocalTest {
        private TestBlockReaderLocalByteBufferReads() {
        }

        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(new byte[12345]);
            TestBlockReaderLocal.readFully(reader, buf, 0, 10);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf.array(), 0, 10);
            TestBlockReaderLocal.readFully(reader, buf, 10, 100);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf.array(), 10, 100);
            TestBlockReaderLocal.readFully(reader, buf, 110, 700);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf.array(), 110, 700);
            reader.skip(1L);
            TestBlockReaderLocal.readFully(reader, buf, 811, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf.array(), 811, 5);
        }
    }

    private static class TestBlockReaderLocalArrayReads2
    implements BlockReaderLocalTest {
        private TestBlockReaderLocalArrayReads2() {
        }

        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] buf = new byte[12345];
            reader.readFully(buf, 0, 10);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf, 0, 10);
            reader.readFully(buf, 10, 100);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf, 10, 100);
            reader.readFully(buf, 110, 700);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf, 110, 700);
            reader.readFully(buf, 810, 1);
            reader.readFully(buf, 811, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf, 811, 5);
            reader.readFully(buf, 816, 900);
            reader.readFully(buf, 1716, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1716, buf, 1716, 5);
        }
    }

    private static class TestBlockReaderSimpleReads
    implements BlockReaderLocalTest {
        private TestBlockReaderSimpleReads() {
        }

        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] buf = new byte[12345];
            reader.readFully(buf, 0, 512);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf, 0, 512);
            reader.readFully(buf, 512, 512);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 512, buf, 512, 512);
            reader.readFully(buf, 1024, 513);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1024, buf, 1024, 513);
            reader.readFully(buf, 1537, 514);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1537, buf, 1537, 514);
        }
    }

    private static class TestBlockReaderLocalImmediateClose
    implements BlockReaderLocalTest {
        private TestBlockReaderLocalImmediateClose() {
        }

        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
        }
    }

    private static interface BlockReaderLocalTest {
        public static final int TEST_LENGTH = 12345;

        public void setup(File var1, boolean var2) throws IOException;

        public void doTest(BlockReaderLocal var1, byte[] var2) throws IOException;
    }
}

