/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbandonBlock {
    public static final Log LOG = LogFactory.getLog(TestAbandonBlock.class);
    private static final Configuration CONF = new HdfsConfiguration();
    static final String FILE_NAME_PREFIX = "/" + TestAbandonBlock.class.getSimpleName() + "_";
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(2).build();
        this.fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        this.fs.close();
        this.cluster.shutdown();
    }

    @Test
    public void testAbandonBlock() throws IOException {
        String src = FILE_NAME_PREFIX + "foo";
        FSDataOutputStream fout = this.fs.create(new Path(src), true, 4096, (short)1, 512L);
        for (int i = 0; i < 1024; ++i) {
            fout.write(123);
        }
        fout.hflush();
        DFSClient dfsclient = DFSClientAdapter.getDFSClient(this.fs);
        LocatedBlocks blocks = dfsclient.getNamenode().getBlockLocations(src, 0L, Integer.MAX_VALUE);
        int orginalNumBlocks = blocks.locatedBlockCount();
        LocatedBlock b = blocks.getLastLocatedBlock();
        dfsclient.getNamenode().abandonBlock(b.getBlock(), src, dfsclient.clientName);
        dfsclient.getNamenode().abandonBlock(b.getBlock(), src, dfsclient.clientName);
        fout.close();
        this.cluster.restartNameNode();
        blocks = dfsclient.getNamenode().getBlockLocations(src, 0L, Integer.MAX_VALUE);
        junit.framework.Assert.assertEquals((String)("Blocks " + b + " has not been abandoned."), (int)orginalNumBlocks, (int)(blocks.locatedBlockCount() + 1));
    }

    @Test
    public void testQuotaUpdatedWhenBlockAbandoned() throws IOException {
        this.fs.setQuota(new Path("/"), Long.MAX_VALUE, 0x300000L);
        String src = FILE_NAME_PREFIX + "test_quota1";
        FSDataOutputStream fout = this.fs.create(new Path(src), true, 4096, (short)2, 0x100000L);
        for (int i = 0; i < 1024; ++i) {
            fout.writeByte(123);
        }
        this.cluster.getDataNodes().get(0).shutdown();
        try {
            fout.close();
        }
        catch (QuotaExceededException e) {
            Assert.fail((String)"Unexpected quota exception when closing fout");
        }
    }
}

