/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

class Histogram<B, T> {
    private Segmenter<B, T> segmenter;
    private int[] counts;
    protected int totalCount;

    public Histogram(Segmenter<B, T> segmenter) {
        this.segmenter = segmenter;
        this.counts = new int[segmenter.size()];
    }

    public void add(T value) {
        int i;
        int n = i = this.segmenter.segment(value);
        this.counts[n] = this.counts[n] + 1;
        ++this.totalCount;
    }

    public int[] getHistogram() {
        return this.counts;
    }

    public int getCount() {
        return this.totalCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Entry<B> e : this.entries()) {
            if (!first) {
                sb.append(";");
            } else {
                first = false;
            }
            sb.append(e.bucket).append("=").append(e.count);
        }
        return sb.toString();
    }

    public Iterable<Entry<B>> entries() {
        return new EntryIterator();
    }

    private class EntryIterator
    implements Iterable<Entry<B>>,
    Iterator<Entry<B>> {
        int i = 0;
        Iterator<B> bucketNameIterator = Histogram.access$200(Histogram.this).getBuckets();

        private EntryIterator() {
        }

        @Override
        public Iterator<Entry<B>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.i < Histogram.this.segmenter.size();
        }

        @Override
        public Entry<B> next() {
            return new Entry(this.bucketNameIterator.next(), Histogram.this.counts[this.i++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Entry<B> {
        B bucket;
        int count;

        public Entry(B bucket, int count) {
            this.bucket = bucket;
            this.count = count;
        }
    }

    public static class TreeMapSegmenter<T extends Comparable<T>>
    implements Segmenter<String, T> {
        private TreeMap<T, Integer> index = new TreeMap();

        public TreeMapSegmenter(SortedSet<T> leftEndpoints) {
            if (leftEndpoints.isEmpty()) {
                throw new IllegalArgumentException("Endpoints must not be empty: " + leftEndpoints);
            }
            int i = 0;
            for (Comparable t : leftEndpoints) {
                this.index.put(t, i++);
            }
        }

        @Override
        public int segment(T value) {
            Map.Entry<T, Integer> e = this.index.floorEntry(value);
            if (e == null) {
                throw new SegmenterException("Could not find bucket for: " + value);
            }
            return e.getValue();
        }

        @Override
        public int size() {
            return this.index.size();
        }

        private String rangeAsString(T a, T b) {
            return String.format("[%s,%s)", a, b == null ? "infinity" : b);
        }

        @Override
        public Iterator<String> getBuckets() {
            return new Iterator<String>(){
                Iterator<T> it;
                T cur;
                {
                    this.it = TreeMapSegmenter.this.index.keySet().iterator();
                    this.cur = (Comparable)this.it.next();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public String next() {
                    Object left = this.cur;
                    this.cur = this.it.hasNext() ? (Comparable)this.it.next() : null;
                    return TreeMapSegmenter.this.rangeAsString(left, this.cur);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class SegmenterException
    extends RuntimeException {
        public SegmenterException(String s) {
            super(s);
        }
    }

    static interface Segmenter<B, T> {
        public int size();

        public int segment(T var1);

        public Iterator<B> getBuckets();
    }
}

