/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;

public class GenericDatumWriter<D>
implements DatumWriter<D> {
    private final GenericData data;
    private Schema root;

    public GenericDatumWriter() {
        this(GenericData.get());
    }

    protected GenericDatumWriter(GenericData data) {
        this.data = data;
    }

    public GenericDatumWriter(Schema root) {
        this();
        this.setSchema(root);
    }

    protected GenericDatumWriter(Schema root, GenericData data) {
        this(data);
        this.setSchema(root);
    }

    @Override
    public void setSchema(Schema root) {
        this.root = root;
    }

    @Override
    public void write(D datum, Encoder out) throws IOException {
        this.write(this.root, datum, out);
    }

    protected void write(Schema schema, Object datum, Encoder out) throws IOException {
        switch (schema.getType()) {
            case RECORD: {
                this.writeRecord(schema, datum, out);
                break;
            }
            case ENUM: {
                this.writeEnum(schema, datum, out);
                break;
            }
            case ARRAY: {
                this.writeArray(schema, datum, out);
                break;
            }
            case MAP: {
                this.writeMap(schema, datum, out);
                break;
            }
            case UNION: {
                int index = this.data.resolveUnion(schema, datum);
                out.writeIndex(index);
                this.write(schema.getTypes().get(index), datum, out);
                break;
            }
            case FIXED: {
                this.writeFixed(schema, datum, out);
                break;
            }
            case STRING: {
                this.writeString(schema, datum, out);
                break;
            }
            case BYTES: {
                this.writeBytes(datum, out);
                break;
            }
            case INT: {
                out.writeInt((Integer)datum);
                break;
            }
            case LONG: {
                out.writeLong((Long)datum);
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)datum).floatValue());
                break;
            }
            case DOUBLE: {
                out.writeDouble((Double)datum);
                break;
            }
            case BOOLEAN: {
                out.writeBoolean((Boolean)datum);
                break;
            }
            case NULL: {
                out.writeNull();
                break;
            }
            default: {
                this.error(schema, datum);
            }
        }
    }

    protected void writeRecord(Schema schema, Object datum, Encoder out) throws IOException {
        for (Schema.Field field : schema.getFields()) {
            this.write(field.schema(), this.getField(datum, field.name(), field.pos()), out);
        }
    }

    protected Object getField(Object record, String field, int position) {
        return ((IndexedRecord)record).get(position);
    }

    protected void writeEnum(Schema schema, Object datum, Encoder out) throws IOException {
        out.writeEnum(schema.getEnumOrdinal((String)datum));
    }

    protected void writeArray(Schema schema, Object datum, Encoder out) throws IOException {
        Schema element = schema.getElementType();
        long size = this.getArraySize(datum);
        out.writeArrayStart();
        out.setItemCount(size);
        Iterator<Object> it = this.getArrayElements(datum);
        while (it.hasNext()) {
            out.startItem();
            this.write(element, it.next(), out);
        }
        out.writeArrayEnd();
    }

    protected long getArraySize(Object array) {
        return ((GenericArray)array).size();
    }

    protected Iterator<? extends Object> getArrayElements(Object array) {
        return ((GenericArray)array).iterator();
    }

    protected void writeMap(Schema schema, Object datum, Encoder out) throws IOException {
        Schema value = schema.getValueType();
        int size = this.getMapSize(datum);
        out.writeMapStart();
        out.setItemCount(size);
        for (Map.Entry<Object, Object> entry : this.getMapEntries(datum)) {
            out.startItem();
            this.writeString(entry.getKey(), out);
            this.write(value, entry.getValue(), out);
        }
        out.writeMapEnd();
    }

    protected int getMapSize(Object map) {
        return ((Map)map).size();
    }

    protected Iterable<Map.Entry<Object, Object>> getMapEntries(Object map) {
        return ((Map)map).entrySet();
    }

    protected void writeString(Schema schema, Object datum, Encoder out) throws IOException {
        this.writeString(datum, out);
    }

    protected void writeString(Object datum, Encoder out) throws IOException {
        out.writeString((Utf8)datum);
    }

    protected void writeBytes(Object datum, Encoder out) throws IOException {
        out.writeBytes((ByteBuffer)datum);
    }

    protected void writeFixed(Schema schema, Object datum, Encoder out) throws IOException {
        out.writeFixed(((GenericFixed)datum).bytes(), 0, schema.getFixedSize());
    }

    private void error(Schema schema, Object datum) {
        throw new AvroTypeException("Not a " + schema + ": " + datum);
    }
}

