/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.directory.shared.ldap.aci.Permission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;

public class UserPermission
extends Permission {
    private static final long serialVersionUID = 3940100745409337694L;
    private final Collection protectedItems;

    public UserPermission(int precedence, Collection grantsAndDenials, Collection protectedItems) {
        super(precedence, grantsAndDenials);
        Iterator i = protectedItems.iterator();
        while (i.hasNext()) {
            Object val = i.next();
            if (val instanceof ProtectedItem) continue;
            throw new IllegalArgumentException("protectedItems contains a wrong element.");
        }
        this.protectedItems = Collections.unmodifiableCollection(protectedItems);
    }

    public Collection getProtectedItems() {
        return this.protectedItems;
    }

    public String toString() {
        return "itemPermission: precedence=" + this.getPrecedence() + ", " + "protectedItems=" + this.protectedItems + ", " + "grantsAndDenials=" + this.getGrantsAndDenials();
    }
}

