/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.sam;

import java.io.IOException;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.kerberos.sam.KeyIntegrityChecker;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.service.LockBox;

public class TimestampChecker
implements KeyIntegrityChecker {
    private static final long FIVE_MINUTES = 300000L;
    private static final LockBox lockBox = new LockBox();

    public boolean checkKeyIntegrity(byte[] encryptedData, KerberosKey kerberosKey) {
        EncryptionType keyType = EncryptionType.getTypeByOrdinal((int)kerberosKey.getKeyType());
        EncryptionKey key = new EncryptionKey(keyType, kerberosKey.getEncoded());
        try {
            EncryptedData sadValue = EncryptedDataDecoder.decode((byte[])encryptedData);
            EncryptedTimeStamp timestamp = (EncryptedTimeStamp)lockBox.unseal(EncryptedTimeStamp.class, key, sadValue);
            KerberosTime time = timestamp.getTimeStamp();
            if (time.isInClockSkew(300000L)) {
                return true;
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (KerberosException ke) {
            return false;
        }
        catch (ClassCastException cce) {
            return false;
        }
        return false;
    }
}

