/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.checksum.RsaMd5Checksum;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.Checksum;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class VerifyBodyChecksum
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)((Object)session.getAttribute(this.getContextKey()));
        byte[] bodyBytes = tgsContext.getRequest().getBodyBytes();
        Checksum checksum = tgsContext.getAuthenticator().getChecksum();
        this.verifyChecksum(checksum, bodyBytes);
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }

    private void verifyChecksum(Checksum checksum, byte[] bytes) throws KerberosException {
        if (checksum == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_INAPP_CKSUM);
        }
        if (!checksum.getChecksumType().equals(ChecksumType.RSA_MD5)) {
            throw new KerberosException(ErrorType.KDC_ERR_SUMTYPE_NOSUPP);
        }
        RsaMd5Checksum digester = new RsaMd5Checksum();
        Checksum newChecksum = new Checksum(digester.checksumType(), digester.calculateChecksum(bytes));
        if (!newChecksum.equals((Object)checksum)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MODIFIED);
        }
    }
}

