/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.loader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.api.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.apache.directory.api.ldap.model.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.api.ldap.model.schema.registries.DefaultSchema;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.schema.loader.AttributeClassLoader;
import org.apache.directory.api.ldap.schema.loader.EntityFactory;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaEntityFactory
implements EntityFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaEntityFactory.class);
    private static final List<String> EMPTY_LIST = new ArrayList<String>();
    private static final String[] EMPTY_ARRAY = new String[0];
    private final AttributeClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<AttributeClassLoader>(){

        @Override
        public AttributeClassLoader run() {
            return new AttributeClassLoader();
        }
    });

    private String getOid(Entry entry, String objectType, boolean strict) throws LdapInvalidAttributeValueException {
        Attribute mOid = entry.get("m-oid");
        if (mOid == null) {
            String msg = I18n.err((I18n)I18n.ERR_10005, (Object[])new Object[]{objectType, "m-oid"});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        String oid = mOid.getString();
        if (strict && !Oid.isOid((String)oid)) {
            String msg = I18n.err((I18n)I18n.ERR_10006, (Object[])new Object[]{oid});
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        return oid;
    }

    private String getOid(SchemaObject description, String objectType) throws LdapInvalidAttributeValueException {
        String oid = description.getOid();
        if (oid == null) {
            String msg = I18n.err((I18n)I18n.ERR_10005, (Object[])new Object[]{objectType, "m-oid"});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!Oid.isOid((String)oid)) {
            String msg = I18n.err((I18n)I18n.ERR_10006, (Object[])new Object[]{oid});
            LOG.warn(msg);
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg);
        }
        return oid;
    }

    private void checkEntry(Entry entry, String schemaEntity) {
        if (entry == null) {
            String msg = I18n.err((I18n)I18n.ERR_10007, (Object[])new Object[]{schemaEntity});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void checkDescription(SchemaObject description, String schemaEntity) {
        if (description == null) {
            String msg = I18n.err((I18n)I18n.ERR_10008, (Object[])new Object[]{schemaEntity});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private Schema getSchema(String schemaName, Registries registries) {
        Schema schema;
        if (Strings.isEmpty((String)schemaName)) {
            schemaName = "other";
        }
        if ((schema = registries.getLoadedSchema(schemaName)) == null) {
            String msg = I18n.err((I18n)I18n.ERR_10009, (Object[])new Object[]{schemaName});
            LOG.error(msg);
        }
        return schema;
    }

    @Override
    public Schema getSchema(Entry entry) throws LdapException {
        String[] dependencies = EMPTY_ARRAY;
        boolean isDisabled = false;
        if (entry == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_10010, (Object[])new Object[0]));
        }
        if (entry.get("cn") == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_10011, (Object[])new Object[0]));
        }
        String name = entry.get("cn").getString();
        if (entry.get("creatorsName") == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_10012, (Object[])new Object[]{"creatorsName"}));
        }
        String owner = entry.get("creatorsName").getString();
        if (entry.get("m-disabled") != null) {
            String value = entry.get("m-disabled").getString();
            value = Strings.upperCase((String)value);
            isDisabled = "TRUE".equalsIgnoreCase(value);
        }
        if (entry.get("m-dependencies") != null) {
            HashSet<String> depsSet = new HashSet<String>();
            Attribute depsAttr = entry.get("m-dependencies");
            for (Value value : depsAttr) {
                depsSet.add(value.getString());
            }
            dependencies = depsSet.toArray(EMPTY_ARRAY);
        }
        return new DefaultSchema(null, name, owner, dependencies, isDisabled);
    }

    private SyntaxChecker classLoadSyntaxChecker(SchemaManager schemaManager, String oid, String className, Attribute byteCode) throws LdapException {
        SyntaxChecker syntaxChecker;
        Class<?> clazz;
        String byteCodeStr = "";
        if (byteCode == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Cannot find the syntax checker class constructor for class {}", (Object)className);
                throw new LdapSchemaException("Cannot find the syntax checker class " + cnfe.getMessage());
            }
        }
        this.classLoader.setAttribute(byteCode);
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Cannot load the syntax checker class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot load the syntax checker class " + cnfe.getMessage());
        }
        byteCodeStr = new String(Base64.encode((byte[])byteCode.getBytes()));
        try {
            Method builder = clazz.getMethod("builder", null);
            syntaxChecker = (SyntaxChecker)((SyntaxChecker.SCBuilder)builder.invoke(null, null)).setOid(oid).build();
        }
        catch (NoSuchMethodException nsme) {
            LOG.error("Cannot instantiate the syntax checker class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot instantiate the syntax checker class " + nsme.getMessage());
        }
        catch (InvocationTargetException ite) {
            LOG.error("Cannot instantiate the syntax checker class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot instantiate the syntax checker class " + ite.getMessage());
        }
        catch (IllegalAccessException iae) {
            LOG.error("Cannot access the syntax checker class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot access the syntax checker class constructor " + iae.getMessage());
        }
        syntaxChecker.setBytecode(byteCodeStr);
        syntaxChecker.setFqcn(className);
        syntaxChecker.setSchemaManager(schemaManager);
        return syntaxChecker;
    }

    @Override
    public SyntaxChecker getSyntaxChecker(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkEntry(entry, "SyntaxChecker");
        String oid = this.getOid(entry, "SyntaxChecker", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10013, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10014, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String className = this.getFqcn(entry, "SyntaxChecker");
        Attribute byteCode = entry.get("m-bytecode");
        try {
            SyntaxChecker syntaxChecker = this.classLoadSyntaxChecker(schemaManager, oid, className, byteCode);
            this.setSchemaObjectProperties((SchemaObject)syntaxChecker, entry, schema);
            return syntaxChecker;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public SyntaxChecker getSyntaxChecker(SchemaManager schemaManager, SyntaxCheckerDescription syntaxCheckerDescription, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkDescription((SchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        String oid = this.getOid((SchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10013, (Object[])new Object[]{syntaxCheckerDescription.getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn((LoadableSchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        Attribute byteCode = this.getByteCode((LoadableSchemaObject)syntaxCheckerDescription, "SyntaxChecker");
        SyntaxChecker syntaxChecker = this.classLoadSyntaxChecker(schemaManager, oid, fqcn, byteCode);
        this.setSchemaObjectProperties((SchemaObject)syntaxChecker, (SchemaObject)syntaxCheckerDescription, schema);
        return syntaxChecker;
    }

    private LdapComparator<?> classLoadComparator(SchemaManager schemaManager, String oid, String className, Attribute byteCode) throws LdapException {
        LdapComparator comparator;
        String byteCodeStr;
        block16: {
            Class<?> clazz;
            byteCodeStr = "";
            if (byteCode == null) {
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    LOG.error("Cannot find the comparator class constructor for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot find the comparator class " + cnfe.getMessage());
                }
            }
            this.classLoader.setAttribute(byteCode);
            try {
                clazz = this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Cannot load the comparator class constructor for class {}", (Object)className);
                throw new LdapSchemaException("Cannot load the comparator class " + cnfe.getMessage());
            }
            byteCodeStr = new String(Base64.encode((byte[])byteCode.getBytes()));
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                try {
                    comparator = (LdapComparator)constructor.newInstance(oid);
                }
                catch (InvocationTargetException ite) {
                    LOG.error("Cannot invoke the comparator class constructor for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot invoke the comparator class " + ite.getMessage());
                }
                catch (InstantiationException ie) {
                    LOG.error("Cannot instanciate the comparator class constructor for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot instanciate the comparator class " + ie.getMessage());
                }
                catch (IllegalAccessException ie) {
                    LOG.error("Cannot access the comparator class constructor for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot access the comparator class " + ie.getMessage());
                }
            }
            catch (NoSuchMethodException nsme) {
                try {
                    clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException nsme2) {
                    LOG.error("Cannot find the comparator class constructor method for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot find the comparator class constructor method" + nsme2.getMessage());
                }
                try {
                    comparator = (LdapComparator)clazz.newInstance();
                }
                catch (InstantiationException ie) {
                    LOG.error("Cannot instantiate the comparator class constructor for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot instantiate the comparator class " + ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    LOG.error("Cannot access the comparator class constructor for class {}", (Object)className);
                    throw new LdapSchemaException("Cannot access the comparator class constructor " + iae.getMessage());
                }
                if (comparator.getOid().equals(oid)) break block16;
                String msg = I18n.err((I18n)I18n.ERR_10015, (Object[])new Object[]{oid, comparator.getOid()});
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg, (Throwable)nsme);
            }
        }
        comparator.setBytecode(byteCodeStr);
        comparator.setFqcn(className);
        comparator.setSchemaManager(schemaManager);
        return comparator;
    }

    @Override
    public LdapComparator<?> getLdapComparator(SchemaManager schemaManager, LdapComparatorDescription comparatorDescription, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkDescription((SchemaObject)comparatorDescription, "Comparator");
        String oid = this.getOid((SchemaObject)comparatorDescription, "Comparator");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10016, (Object[])new Object[]{comparatorDescription.getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn((LoadableSchemaObject)comparatorDescription, "Comparator");
        Attribute byteCode = this.getByteCode((LoadableSchemaObject)comparatorDescription, "Comparator");
        LdapComparator<?> comparator = this.classLoadComparator(schemaManager, oid, fqcn, byteCode);
        this.setSchemaObjectProperties((SchemaObject)comparator, (SchemaObject)comparatorDescription, schema);
        return comparator;
    }

    @Override
    public LdapComparator<?> getLdapComparator(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkEntry(entry, "Comparator");
        String oid = this.getOid(entry, "Comparator", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10016, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10017, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String fqcn = this.getFqcn(entry, "Comparator");
        Attribute byteCode = entry.get("m-bytecode");
        try {
            LdapComparator<?> comparator = this.classLoadComparator(schemaManager, oid, fqcn, byteCode);
            this.setSchemaObjectProperties((SchemaObject)comparator, entry, schema);
            return comparator;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), (Throwable)e);
        }
    }

    private Normalizer classLoadNormalizer(SchemaManager schemaManager, String oid, String className, Attribute byteCode) throws LdapException {
        Normalizer normalizer;
        Class<?> clazz;
        String byteCodeStr = "";
        if (byteCode == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Cannot find the normalizer class constructor for class {}", (Object)className);
                throw new LdapSchemaException("Cannot find the normalizer class " + cnfe.getMessage());
            }
        }
        this.classLoader.setAttribute(byteCode);
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Cannot load the normalizer class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot load the normalizer class " + cnfe.getMessage());
        }
        byteCodeStr = new String(Base64.encode((byte[])byteCode.getBytes()));
        try {
            normalizer = (Normalizer)clazz.newInstance();
        }
        catch (InstantiationException ie) {
            LOG.error("Cannot instantiate the normalizer class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot instantiate the normalizer class " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            LOG.error("Cannot access the normalizer class constructor for class {}", (Object)className);
            throw new LdapSchemaException("Cannot access the normalizer class constructor " + iae.getMessage());
        }
        normalizer.setBytecode(byteCodeStr);
        normalizer.setFqcn(className);
        normalizer.setOid(oid);
        normalizer.setSchemaManager(schemaManager);
        return normalizer;
    }

    @Override
    public Normalizer getNormalizer(SchemaManager schemaManager, NormalizerDescription normalizerDescription, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkDescription((SchemaObject)normalizerDescription, "Normalizer");
        String oid = this.getOid((SchemaObject)normalizerDescription, "Normalizer");
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10018, (Object[])new Object[]{normalizerDescription.getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        String fqcn = this.getFqcn((LoadableSchemaObject)normalizerDescription, "Normalizer");
        Attribute byteCode = this.getByteCode((LoadableSchemaObject)normalizerDescription, "Normalizer");
        Normalizer normalizer = this.classLoadNormalizer(schemaManager, oid, fqcn, byteCode);
        this.setSchemaObjectProperties((SchemaObject)normalizer, (SchemaObject)normalizerDescription, schema);
        return normalizer;
    }

    @Override
    public Normalizer getNormalizer(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        this.checkEntry(entry, "Normalizer");
        String oid = this.getOid(entry, "Normalizer", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10018, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10019, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        String className = this.getFqcn(entry, "Normalizer");
        Attribute byteCode = entry.get("m-bytecode");
        try {
            Normalizer normalizer = this.classLoadNormalizer(schemaManager, oid, className, byteCode);
            this.setSchemaObjectProperties((SchemaObject)normalizer, entry, schema);
            return normalizer;
        }
        catch (Exception e) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public LdapSyntax getSyntax(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapInvalidAttributeValueException, LdapUnwillingToPerformException {
        this.checkEntry(entry, "Syntax");
        String oid = this.getOid(entry, "Syntax", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10020, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10021, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        LdapSyntax syntax = new LdapSyntax(oid);
        this.setSchemaObjectProperties((SchemaObject)syntax, entry, schema);
        return syntax;
    }

    @Override
    public MatchingRule getMatchingRule(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapUnwillingToPerformException, LdapInvalidAttributeValueException {
        this.checkEntry(entry, "MatchingRule");
        String oid = this.getOid(entry, "MatchingRule", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10022, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10023, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MutableMatchingRule matchingRule = new MutableMatchingRule(oid);
        Attribute mSyntax = entry.get("m-syntax");
        if (mSyntax != null) {
            matchingRule.setSyntaxOid(mSyntax.getString());
        }
        this.setSchemaObjectProperties((SchemaObject)matchingRule, entry, schema);
        return matchingRule;
    }

    private List<String> getStrings(Attribute attr) {
        if (attr == null) {
            return EMPTY_LIST;
        }
        ArrayList<String> strings = new ArrayList<String>(attr.size());
        for (Value value : attr) {
            strings.add(value.getString());
        }
        return strings;
    }

    @Override
    public ObjectClass getObjectClass(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapException {
        Attribute mTypeObjectClass;
        Attribute mMust;
        Attribute mMay;
        this.checkEntry(entry, "ObjectCLass");
        String oid = this.getOid(entry, "ObjectCLass", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10024, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10025, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MutableObjectClass oc = new MutableObjectClass(oid);
        Attribute mSuperiors = entry.get("m-supObjectClass");
        if (mSuperiors != null) {
            oc.setSuperiorOids(this.getStrings(mSuperiors));
        }
        if ((mMay = entry.get("m-may")) != null) {
            oc.setMayAttributeTypeOids(this.getStrings(mMay));
        }
        if ((mMust = entry.get("m-must")) != null) {
            oc.setMustAttributeTypeOids(this.getStrings(mMust));
        }
        if ((mTypeObjectClass = entry.get("m-typeObjectClass")) != null) {
            String type = mTypeObjectClass.getString();
            oc.setType(ObjectClassTypeEnum.getClassType((String)type));
        }
        this.setSchemaObjectProperties((SchemaObject)oc, entry, schema);
        return oc;
    }

    @Override
    public AttributeType getAttributeType(SchemaManager schemaManager, Entry entry, Registries targetRegistries, String schemaName) throws LdapInvalidAttributeValueException, LdapUnwillingToPerformException {
        Attribute mUsage;
        Attribute mNoUserModification;
        Attribute mSingleValued;
        Attribute mCollective;
        Attribute mSupAttributeType;
        Attribute mSubstr;
        Attribute mOrdering;
        Attribute mEquality;
        Attribute mSyntaxLength;
        Attribute mSyntax;
        this.checkEntry(entry, "AttributeType");
        String oid = this.getOid(entry, "AttributeType", schemaManager.isStrict());
        if (!schemaManager.isSchemaLoaded(schemaName)) {
            String msg = I18n.err((I18n)I18n.ERR_10026, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.warn(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        Schema schema = this.getSchema(schemaName, targetRegistries);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_10027, (Object[])new Object[]{entry.getDn().getName(), schemaName});
            LOG.info(msg);
            schema = schemaManager.getLoadedSchema(schemaName);
        }
        MutableAttributeType attributeType = new MutableAttributeType(oid);
        if (schemaManager.isRelaxed()) {
            attributeType.setRelaxed(true);
        }
        if ((mSyntax = entry.get("m-syntax")) != null && mSyntax.get() != null) {
            attributeType.setSyntaxOid(mSyntax.getString());
        }
        if ((mSyntaxLength = entry.get("m-length")) != null) {
            attributeType.setSyntaxLength((long)Integer.parseInt(mSyntaxLength.getString()));
        }
        if ((mEquality = entry.get("m-equality")) != null) {
            attributeType.setEqualityOid(mEquality.getString());
        }
        if ((mOrdering = entry.get("m-ordering")) != null) {
            attributeType.setOrderingOid(mOrdering.getString());
        }
        if ((mSubstr = entry.get("m-substr")) != null) {
            attributeType.setSubstringOid(mSubstr.getString());
        }
        if ((mSupAttributeType = entry.get("m-supAttributeType")) != null) {
            attributeType.setSuperiorOid(mSupAttributeType.getString());
        }
        if ((mCollective = entry.get("m-collective")) != null) {
            String val = mCollective.getString();
            attributeType.setCollective("TRUE".equalsIgnoreCase(val));
        }
        if ((mSingleValued = entry.get("m-singleValue")) != null) {
            String val = mSingleValued.getString();
            attributeType.setSingleValued("TRUE".equalsIgnoreCase(val));
        }
        if ((mNoUserModification = entry.get("m-noUserModification")) != null) {
            String val = mNoUserModification.getString();
            attributeType.setUserModifiable(!"TRUE".equalsIgnoreCase(val));
        }
        if ((mUsage = entry.get("m-usage")) != null) {
            attributeType.setUsage(UsageEnum.getUsage((String)mUsage.getString()));
        }
        this.setSchemaObjectProperties((SchemaObject)attributeType, entry, schema);
        return attributeType;
    }

    private String getFqcn(Entry entry, String objectType) throws LdapInvalidAttributeValueException {
        Attribute mFqcn = entry.get("m-fqcn");
        if (mFqcn == null) {
            String msg = I18n.err((I18n)I18n.ERR_10028, (Object[])new Object[]{objectType, "m-fqcn"});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        return mFqcn.getString();
    }

    private String getFqcn(LoadableSchemaObject description, String objectType) {
        String mFqcn = description.getFqcn();
        if (mFqcn == null) {
            String msg = I18n.err((I18n)I18n.ERR_10028, (Object[])new Object[]{objectType, "m-fqcn"});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        return mFqcn;
    }

    private Attribute getByteCode(LoadableSchemaObject description, String objectType) {
        String byteCodeString = description.getBytecode();
        if (byteCodeString == null) {
            String msg = I18n.err((I18n)I18n.ERR_10028, (Object[])new Object[]{objectType, "m-bytecode"});
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] bytecode = Base64.decode((char[])byteCodeString.toCharArray());
        return new DefaultAttribute("m-bytecode", (byte[][])new byte[][]{bytecode});
    }

    private String getStringValue(Attribute attribute) {
        Value value = attribute.get();
        if (value instanceof BinaryValue) {
            return Strings.utf8ToString((byte[])value.getBytes());
        }
        return value.getString();
    }

    private void setSchemaObjectProperties(SchemaObject schemaObject, Entry entry, Schema schema) throws LdapInvalidAttributeValueException {
        Attribute xReadOnly;
        Attribute xNotHumanReadable;
        Attribute mDisabled;
        Attribute names;
        Attribute mDescription;
        Attribute mObsolete = entry.get("m-obsolete");
        if (mObsolete != null) {
            String val = mObsolete.getString();
            schemaObject.setObsolete("TRUE".equalsIgnoreCase(val));
        }
        if ((mDescription = entry.get("m-description")) != null) {
            schemaObject.setDescription(this.getStringValue(mDescription));
        }
        if ((names = entry.get("m-name")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Value name : names) {
                values.add(name.getString());
            }
            schemaObject.setNames(values);
        }
        if ((mDisabled = entry.get("m-disabled")) != null) {
            String val = mDisabled.getString();
            schemaObject.setEnabled(!"TRUE".equalsIgnoreCase(val));
        } else {
            schemaObject.setEnabled(schema.isEnabled());
        }
        schemaObject.setSchemaName(schema.getSchemaName());
        Attribute xSchema = entry.get("X-SCHEMA");
        if (xSchema != null) {
            String schemaName = xSchema.getString();
            if (!schema.getSchemaName().equalsIgnoreCase(schemaName)) {
                LOG.warn("Schema (" + schema.getSchemaName() + ") and X-SCHEMA (" + schemaName + ") are different : " + entry);
            }
            schemaObject.addExtension("X-SCHEMA", new String[]{schemaName});
        }
        if ((xNotHumanReadable = entry.get("X-NOT-HUMAN-READABLE")) != null) {
            String value = xNotHumanReadable.getString();
            schemaObject.addExtension("X-NOT-HUMAN-READABLE", new String[]{value});
        }
        if ((xReadOnly = entry.get("X-READ-ONLY")) != null) {
            String value = xReadOnly.getString();
            schemaObject.addExtension("X-READ-ONLY", new String[]{value});
        }
    }

    private void setSchemaObjectProperties(SchemaObject schemaObject, SchemaObject description, Schema schema) {
        schemaObject.setObsolete(description.isObsolete());
        schemaObject.setDescription(description.getDescription());
        schemaObject.setNames(description.getNames());
        schemaObject.setEnabled(schema.isEnabled());
        schemaObject.setReadOnly(false);
        schemaObject.setSpecification(description.getSpecification());
        schemaObject.setSchemaName(schema.getSchemaName());
        schemaObject.setExtensions(description.getExtensions());
    }
}

