/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.staxutils.StaxUtils;

@Provider
@Produces(value={"application/xml", "application/*+xml", "text/xml"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class DataBindingProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private DataBinding binding;

    public DataBindingProvider() {
    }

    public DataBindingProvider(DataBinding db) {
        this.binding = db;
    }

    public void setDataBinding(DataBinding db) {
        this.binding = db;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    public T readFrom(Class<T> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            XMLStreamReader reader = this.createReader(clazz, genericType, is);
            DataReader dataReader = this.binding.createReader(XMLStreamReader.class);
            Object o = dataReader.read(null, (Object)reader, clazz);
            return o == null ? null : (T)clazz.cast(o);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected XMLStreamReader createReader(Class<?> clazz, Type genericType, InputStream is) throws Exception {
        return StaxUtils.createXMLStreamReader((InputStream)is);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (byte[].class.isAssignableFrom(t.getClass())) {
            return ((byte[])t).length;
        }
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return true;
    }

    public void writeTo(T o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            XMLStreamWriter writer = this.createWriter(clazz, genericType, os);
            this.writeToWriter(writer, o);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected void writeToWriter(XMLStreamWriter writer, Object o) throws Exception {
        DataWriter dataWriter = this.binding.createWriter(XMLStreamWriter.class);
        dataWriter.write(o, (Object)writer);
        writer.flush();
    }

    protected XMLStreamWriter createWriter(Class<?> clazz, Type genericType, OutputStream os) throws Exception {
        return StaxUtils.createXMLStreamWriter((OutputStream)os);
    }
}

