/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class AsyncResponseImpl
implements AsyncResponse,
ContinuationCallback {
    private Continuation cont;
    private long timeout = 0L;
    private Message inMessage;
    private boolean cancelled;
    private boolean done;
    private boolean newTimeoutRequested;
    private boolean resumedByApplication;
    private TimeoutHandler timeoutHandler;
    private CompletionCallback completionCallback;

    public AsyncResponseImpl(Message inMessage) {
        inMessage.put(AsyncResponse.class, (Object)this);
        inMessage.getExchange().put(ContinuationCallback.class, (Object)this);
        this.inMessage = inMessage;
        ContinuationProvider provider = (ContinuationProvider)inMessage.get((Object)ContinuationProvider.class.getName());
        this.cont = provider.getContinuation();
    }

    public void resume(Object response) throws IllegalStateException {
        this.doResume(response);
    }

    public void resume(Throwable response) throws IllegalStateException {
        this.doResume(response);
    }

    private synchronized void doResume(Object response) throws IllegalStateException {
        this.checkCancelled();
        this.checkSuspended();
        this.inMessage.getExchange().put(AsyncResponse.class, (Object)this);
        this.cont.setObject(response);
        this.resumedByApplication = true;
        this.cont.resume();
    }

    public void cancel() {
        this.doCancel(null);
    }

    public void cancel(int retryAfter) {
        this.doCancel(Integer.toString(retryAfter));
    }

    public void cancel(Date retryAfter) {
        this.doCancel(HttpUtils.getHttpDateFormat().format(retryAfter));
    }

    private synchronized void doCancel(String retryAfterHeader) {
        this.checkSuspended();
        this.cancelled = true;
        Response.ResponseBuilder rb = Response.status((int)503);
        if (retryAfterHeader != null) {
            rb.header("Retry-After", (Object)retryAfterHeader);
        }
        this.doResume(rb.build());
    }

    public synchronized boolean isSuspended() {
        return this.cont.isPending();
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized void setTimeout(long time, TimeUnit unit) throws IllegalStateException {
        this.checkCancelled();
        this.checkSuspended();
        this.inMessage.getExchange().put(AsyncResponse.class, (Object)this);
        this.timeout = unit.convert(time, TimeUnit.MILLISECONDS);
        this.newTimeoutRequested = true;
        this.cont.resume();
    }

    public void setTimeoutHandler(TimeoutHandler handler) {
        this.timeoutHandler = handler;
    }

    public boolean register(Class<?> callback) throws NullPointerException {
        return this.register(callback, CompletionCallback.class)[0];
    }

    public boolean[] register(Class<?> callback, Class<?> ... callbacks) throws NullPointerException {
        try {
            return this.register(callback.newInstance(), CompletionCallback.class);
        }
        catch (Throwable t) {
            return new boolean[]{false};
        }
    }

    public boolean register(Object callback) throws NullPointerException {
        return this.register(callback, CompletionCallback.class)[0];
    }

    public boolean[] register(Object callback, Object ... callbacks) throws NullPointerException {
        boolean[] result = new boolean[callbacks.length];
        for (int i = 0; i < callbacks.length; ++i) {
            Object interf = callbacks[i];
            if (interf == null) {
                throw new NullPointerException();
            }
            Class cls = (Class)interf;
            if (cls == CompletionCallback.class) {
                this.completionCallback = (CompletionCallback)callback;
                result[i] = true;
                continue;
            }
            result[i] = false;
        }
        return result;
    }

    private void checkCancelled() {
        if (this.cancelled) {
            throw new IllegalStateException();
        }
    }

    private void checkSuspended() {
        if (!this.cont.isPending()) {
            throw new IllegalStateException();
        }
    }

    public synchronized void suspend() {
        this.checkCancelled();
        this.cont.suspend(this.timeout);
    }

    public synchronized Object getResponseObject() {
        this.done = true;
        return this.cont.getObject();
    }

    public synchronized boolean isResumedByApplication() {
        return this.resumedByApplication;
    }

    public synchronized boolean handleTimeout() {
        if (!this.resumedByApplication) {
            if (this.newTimeoutRequested) {
                this.newTimeoutRequested = false;
                this.suspend();
                return true;
            }
            if (this.timeoutHandler != null) {
                this.suspend();
                this.timeoutHandler.handleTimeout((AsyncResponse)this);
                return true;
            }
            this.done = true;
        }
        return false;
    }

    public void onComplete() {
        if (this.completionCallback != null) {
            this.completionCallback.onComplete();
        }
    }

    public void onError(Throwable error) {
        if (this.completionCallback != null) {
            this.completionCallback.onError(error);
        }
    }
}

