/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint.dynamic;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.dynamic.TypeClassInitializer;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.util.Compiler;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicClientFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(DynamicClientFactory.class);
    private Bus bus;
    private String tmpdir = System.getProperty("java.io.tmpdir");
    private boolean simpleBindingEnabled = true;
    private Map<String, Object> jaxbContextProperties;

    private DynamicClientFactory(Bus bus) {
        this.bus = bus;
    }

    public void setTemporaryDirectory(String dir) {
        this.tmpdir = dir;
    }

    public static DynamicClientFactory newInstance(Bus b) {
        return new DynamicClientFactory(b);
    }

    public static DynamicClientFactory newInstance() {
        Bus bus = CXFBusFactory.getThreadDefaultBus();
        return new DynamicClientFactory(bus);
    }

    public Client createClient(String wsdlUrl) {
        return this.createClient(wsdlUrl, null, null);
    }

    public Client createClient(String wsdlUrl, ClassLoader classLoader) {
        return this.createClient(wsdlUrl, null, classLoader, null);
    }

    public Client createClient(String wsdlUrl, QName service) {
        return this.createClient(wsdlUrl, service, null);
    }

    public Client createClient(String wsdlUrl, QName service, QName port) {
        return this.createClient(wsdlUrl, service, null, port);
    }

    public Client createClient(String wsdlUrl, QName service, ClassLoader classLoader, QName port) {
        JAXBContext context;
        URLClassLoader cl;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        URL u = this.composeUrl(wsdlUrl);
        LOG.log(Level.FINE, "Creating client from URL " + u.toString());
        ClientImpl client = new ClientImpl(this.bus, u, service, port);
        Service svc = client.getEndpoint().getService();
        List schemas = ((ServiceInfo)svc.getServiceInfos().get(0)).getSchemas();
        SchemaCompiler compiler = XJC.createSchemaCompiler();
        InnerErrorListener elForRun = new InnerErrorListener(wsdlUrl);
        compiler.setErrorListener((ErrorListener)elForRun);
        this.addSchemas(wsdlUrl, schemas, compiler);
        S2JJAXBModel intermediateModel = compiler.bind();
        JCodeModel codeModel = intermediateModel.generateCode(null, (ErrorListener)elForRun);
        StringBuilder sb = new StringBuilder();
        boolean firstnt = false;
        Iterator packages = codeModel.packages();
        while (packages.hasNext()) {
            JPackage jpackage = (JPackage)packages.next();
            if (!this.isValidPackage(jpackage)) continue;
            if (firstnt) {
                sb.append(':');
            } else {
                firstnt = true;
            }
            sb.append(jpackage.name());
        }
        this.outputDebug(codeModel);
        String packageList = sb.toString();
        String stem = this.toString() + "-" + System.currentTimeMillis();
        File src = new File(this.tmpdir, stem + "-src");
        if (!src.mkdir()) {
            throw new IllegalStateException("Unable to create working directory " + src.getPath());
        }
        try {
            FileCodeWriter writer = new FileCodeWriter(src);
            codeModel.build((CodeWriter)writer);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write generated Java files for schemas: " + e.getMessage(), e);
        }
        File classes = new File(this.tmpdir, stem + "-classes");
        if (!classes.mkdir()) {
            throw new IllegalStateException("Unable to create working directory " + src.getPath());
        }
        Project project = new Project();
        project.setBaseDir(new File(this.tmpdir));
        Path classPath = new Path(project);
        DynamicClientFactory.setupClasspath(classPath, classLoader);
        Path srcPath = new Path(project);
        FileSet fileSet = new FileSet();
        fileSet.setDir(src);
        srcPath.addFileset(fileSet);
        if (!DynamicClientFactory.compileJavaSrc(classPath, srcPath, classes.toString())) {
            LOG.log(Level.SEVERE, new Message("COULD_NOT_COMPILE_SRC", LOG, new Object[]{wsdlUrl}).toString());
        }
        FileUtils.removeDir((File)src);
        try {
            cl = new URLClassLoader(new URL[]{classes.toURI().toURL()}, classLoader);
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Internal error; a directory returns a malformed URL: " + mue.getMessage(), mue);
        }
        Map<String, Object> contextProperties = this.jaxbContextProperties;
        if (contextProperties == null) {
            contextProperties = Collections.emptyMap();
        }
        try {
            context = StringUtils.isEmpty((String)packageList) ? JAXBContext.newInstance((Class[])new Class[0], contextProperties) : JAXBContext.newInstance((String)packageList, (ClassLoader)cl, contextProperties);
        }
        catch (JAXBException jbe) {
            throw new IllegalStateException("Unable to create JAXBContext for generated packages: " + jbe.getMessage(), jbe);
        }
        JAXBDataBinding databinding = new JAXBDataBinding();
        databinding.setContext(context);
        svc.setDataBinding((DataBinding)databinding);
        ServiceInfo svcfo = client.getEndpoint().getEndpointInfo().getService();
        Thread.currentThread().setContextClassLoader(cl);
        TypeClassInitializer visitor = new TypeClassInitializer(svcfo, intermediateModel);
        visitor.walk();
        FileUtils.removeDir((File)classes);
        return client;
    }

    private boolean isValidPackage(JPackage jpackage) {
        if (jpackage == null) {
            return false;
        }
        String name = jpackage.name();
        if ("org.w3._2001.xmlschema".equals(name) || "java.lang".equals(name) || "java.io".equals(name) || "generated".equals(name)) {
            return false;
        }
        Iterator i = jpackage.classes();
        while (i.hasNext()) {
            JDefinedClass current = (JDefinedClass)i.next();
            if (!"ObjectFactory".equals(current.name())) continue;
            return true;
        }
        return false;
    }

    private void outputDebug(JCodeModel codeModel) {
        if (!LOG.isLoggable(Level.INFO)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator itr = codeModel.packages();
        while (itr.hasNext()) {
            JPackage package1 = (JPackage)itr.next();
            Iterator citr = package1.classes();
            while (citr.hasNext()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(((JDefinedClass)citr.next()).fullName());
            }
        }
        LOG.log(Level.INFO, "Created classes: " + sb.toString());
    }

    private void addSchemas(String wsdlUrl, Collection<SchemaInfo> schemas, SchemaCompiler compiler) {
        int num = 1;
        for (SchemaInfo schema : schemas) {
            Element el = schema.getElement();
            compiler.parseSchema(wsdlUrl + "#types" + num, el);
            ++num;
        }
        if (this.simpleBindingEnabled && this.isJaxb21()) {
            String id = "/org/apache/cxf/endpoint/dynamic/simple-binding.xjb";
            LOG.info("Loading the JAXB 2.1 simple binding for client.");
            InputSource source = new InputSource(this.getClass().getResourceAsStream(id));
            source.setSystemId(id);
            compiler.parseSchema(source);
        }
    }

    private boolean isJaxb21() {
        String id = Options.getBuildID();
        StringTokenizer st = new StringTokenizer(id, ".");
        String minor = null;
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            minor = st.nextToken();
        }
        try {
            int i = Integer.valueOf(minor);
            if (i >= 1) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isSimpleBindingEnabled() {
        return this.simpleBindingEnabled;
    }

    public void setSimpleBindingEnabled(boolean simpleBindingEnabled) {
        this.simpleBindingEnabled = simpleBindingEnabled;
    }

    static boolean compileJavaSrc(Path classPath, Path srcPath, String dest) {
        String[] srcList = srcPath.list();
        String[] javacCommand = new String[srcList.length + 7];
        javacCommand[0] = "javac";
        javacCommand[1] = "-classpath";
        javacCommand[2] = classPath.toString();
        javacCommand[3] = "-d";
        javacCommand[4] = dest.toString();
        javacCommand[5] = "-target";
        javacCommand[6] = "1.5";
        for (int i = 0; i < srcList.length; ++i) {
            javacCommand[7 + i] = srcList[i];
        }
        Compiler javaCompiler = new Compiler();
        return javaCompiler.internalCompile(javacCommand, 7);
    }

    static void setupClasspath(Path classPath, ClassLoader classLoader) {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ClassLoader tcl = classLoader;
        do {
            if (!(tcl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)tcl).getURLs();
            if (urls == null) {
                urls = new URL[]{};
            }
            for (URL url : urls) {
                if (!url.getProtocol().startsWith("file")) continue;
                try {
                    File file = new File(url.toURI().getPath());
                    if (file.isDirectory()) {
                        DirSet ds = new DirSet();
                        ds.setFile(file);
                        classPath.addDirset(ds);
                        continue;
                    }
                    FileSet fs = new FileSet();
                    fs.setFile(file);
                    classPath.addFileset(fs);
                }
                catch (URISyntaxException e) {
                    throw new UncheckedException((Throwable)e);
                }
            }
        } while (null != (tcl = tcl.getParent()) && !tcl.equals(scl));
    }

    private URL composeUrl(String s) {
        try {
            URIResolver resolver = new URIResolver(null, s, this.getClass());
            if (resolver.isResolved()) {
                return resolver.getURI().toURL();
            }
            throw new ServiceConstructionException(new Message("COULD_NOT_RESOLVE_URL", LOG, new Object[]{s}));
        }
        catch (IOException e) {
            throw new ServiceConstructionException(new Message("COULD_NOT_RESOLVE_URL", LOG, new Object[]{s}), (Throwable)e);
        }
    }

    public Map<String, Object> getJaxbContextProperties() {
        return this.jaxbContextProperties;
    }

    public void setJaxbContextProperties(Map<String, Object> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    static class RelativeEntityResolver
    implements EntityResolver {
        private String baseURI;

        public RelativeEntityResolver(String baseURI) {
            this.baseURI = baseURI;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId != null) {
                File file = new File(this.baseURI, systemId);
                if (file.exists()) {
                    return new InputSource(new FileInputStream(file));
                }
                return new InputSource(systemId);
            }
            return null;
        }
    }

    private class InnerErrorListener
    implements ErrorListener {
        private String url;

        InnerErrorListener(String url) {
            this.url = url;
        }

        public void error(SAXParseException arg0) {
            throw new RuntimeException("Error compiling schema from WSDL at {" + this.url + "}: " + arg0.getMessage(), arg0);
        }

        public void fatalError(SAXParseException arg0) {
            throw new RuntimeException("Fatal error compiling schema from WSDL at {" + this.url + "}: " + arg0.getMessage(), arg0);
        }

        public void info(SAXParseException arg0) {
        }

        public void warning(SAXParseException arg0) {
        }
    }
}

